/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import com.opensymphony.xwork2.util.finder.Test;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.ConventionsService;
import org.apache.struts2.convention.ReflectionTools;
import org.apache.struts2.convention.ResultMapBuilder;
import org.apache.struts2.convention.StringTools;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResultMapBuilder
implements ResultMapBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResultMapBuilder.class);
    private final ServletContext servletContext;
    private Set<String> relativeResultTypes;
    private ConventionsService conventionsService;
    private boolean flatResultLayout = true;

    @Inject
    public DefaultResultMapBuilder(ServletContext servletContext, Container container, @Inject(value="struts.convention.relative.result.types") String relativeResultTypes) {
        this.servletContext = servletContext;
        this.relativeResultTypes = new HashSet<String>(Arrays.asList(relativeResultTypes.split("\\s*[,]\\s*")));
        this.conventionsService = (ConventionsService)container.getInstance(ConventionsService.class, (String)container.getInstance(String.class, "struts.convention.conventionsService"));
    }

    @Inject(value="struts.convention.result.flatLayout")
    public void setFlatResultLayout(String flatResultLayout) {
        this.flatResultLayout = "true".equals(flatResultLayout);
    }

    @Override
    public Map<String, ResultConfig> build(Class<?> actionClass, Action annotation, String actionName, PackageConfig packageConfig) {
        String namespace;
        String defaultResultPath = this.conventionsService.determineResultPath(actionClass);
        if (!defaultResultPath.endsWith("/")) {
            defaultResultPath = defaultResultPath + "/";
        }
        if ((namespace = packageConfig.getNamespace()) != null && namespace.startsWith("/")) {
            defaultResultPath = defaultResultPath + namespace.substring(1);
        } else if (namespace != null) {
            defaultResultPath = defaultResultPath + namespace;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using final calculated namespace [#0]", new String[]{namespace});
        }
        if (!defaultResultPath.endsWith("/")) {
            defaultResultPath = defaultResultPath + "/";
        }
        String resultPrefix = defaultResultPath + actionName;
        HashMap<String, ResultConfig> results = new HashMap<String, ResultConfig>();
        Map<String, ResultTypeConfig> resultsByExtension = this.conventionsService.getResultTypesByExtension(packageConfig);
        this.createFromResources(actionClass, results, defaultResultPath, resultPrefix, actionName, packageConfig, resultsByExtension);
        for (Class<?> clazz : ReflectionTools.getClassHierarchy(actionClass)) {
            this.createResultsFromAnnotations(clazz, packageConfig, defaultResultPath, results, resultsByExtension);
        }
        if (annotation != null && annotation.results() != null && annotation.results().length > 0) {
            this.createFromAnnotations(results, defaultResultPath, packageConfig, annotation.results(), actionClass, resultsByExtension);
        }
        return results;
    }

    protected void createResultsFromAnnotations(Class<?> actionClass, PackageConfig packageConfig, String defaultResultPath, Map<String, ResultConfig> results, Map<String, ResultTypeConfig> resultsByExtension) {
        Result resultAnn;
        Results resultsAnn = actionClass.getAnnotation(Results.class);
        if (resultsAnn != null) {
            this.createFromAnnotations(results, defaultResultPath, packageConfig, resultsAnn.value(), actionClass, resultsByExtension);
        }
        if ((resultAnn = actionClass.getAnnotation(Result.class)) != null) {
            this.createFromAnnotations(results, defaultResultPath, packageConfig, new Result[]{resultAnn}, actionClass, resultsByExtension);
        }
    }

    protected void createFromResources(Class<?> actionClass, Map<String, ResultConfig> results, String resultPath, String resultPrefix, String actionName, PackageConfig packageConfig, Map<String, ResultTypeConfig> resultsByExtension) {
        block13: {
            String classPathLocation;
            Set paths;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Searching for results in the Servlet container at [#0] with result prefix of [#1]", new String[]{resultPath, resultPrefix});
            }
            if ((paths = this.servletContext.getResourcePaths(this.flatResultLayout ? resultPath : resultPrefix)) != null) {
                for (String path : paths) {
                    String fileName;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Processing resource path [#0]", new String[]{path});
                    }
                    if (StringUtils.isBlank((String)(fileName = StringUtils.substringAfterLast((String)path, (String)"/"))) || StringUtils.startsWith((String)fileName, (String)".")) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Ignoring file without name [#0]", new String[]{path});
                        continue;
                    }
                    if (fileName.lastIndexOf(".") > 0) {
                        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                        if (this.conventionsService.getResultTypesByExtension(packageConfig).get(suffix) == null) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("No result type defined for file suffix : [#0]. Ignoring file #1", new String[]{suffix, fileName});
                            continue;
                        }
                    }
                    this.makeResults(actionClass, path, resultPrefix, results, packageConfig, resultsByExtension);
                }
            }
            String string = classPathLocation = resultPath.startsWith("/") ? resultPath.substring(1, resultPath.length()) : resultPath;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Searching for results in the class path at [#0] with a result prefix of [#1] and action name [#2]", new String[]{classPathLocation, resultPrefix, actionName});
            }
            ResourceFinder finder = new ResourceFinder(classPathLocation, this.getClassLoaderInterface());
            try {
                Map matches = finder.getResourcesMap("");
                if (matches != null) {
                    Test<URL> resourceTest = this.getResourceTest(resultPath, actionName);
                    for (Map.Entry entry : matches.entrySet()) {
                        if (!resourceTest.test(entry.getValue())) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Processing URL [#0]", new String[]{(String)entry.getKey()});
                        }
                        String urlStr = ((URL)entry.getValue()).toString();
                        int index = urlStr.lastIndexOf(resultPrefix);
                        String path = urlStr.substring(index);
                        this.makeResults(actionClass, path, resultPrefix, results, packageConfig, resultsByExtension);
                    }
                }
            }
            catch (IOException ex) {
                if (!LOG.isErrorEnabled()) break block13;
                LOG.error("Unable to scan directory [#0] for results", (Throwable)ex, new String[]{classPathLocation});
            }
        }
    }

    protected ClassLoaderInterface getClassLoaderInterface() {
        ClassLoaderInterface classLoaderInterface = null;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            classLoaderInterface = (ClassLoaderInterface)ctx.get("__current_class_loader_interface");
        }
        return (ClassLoaderInterface)ObjectUtils.defaultIfNull((Object)classLoaderInterface, (Object)new ClassLoaderInterfaceDelegate(Thread.currentThread().getContextClassLoader()));
    }

    private Test<URL> getResourceTest(final String resultPath, final String actionName) {
        return new Test<URL>(){

            public boolean test(URL url) {
                String urlStr = url.toString();
                int index = urlStr.lastIndexOf(resultPath);
                String path = urlStr.substring(index + resultPath.length());
                return path.startsWith(actionName);
            }
        };
    }

    protected void makeResults(Class<?> actionClass, String path, String resultPrefix, Map<String, ResultConfig> results, PackageConfig packageConfig, Map<String, ResultTypeConfig> resultsByExtension) {
        if (path.startsWith(resultPrefix)) {
            int indexOfDot = path.indexOf(46, resultPrefix.length());
            if (indexOfDot == resultPrefix.length() || !this.flatResultLayout) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The result file [#0] has no result code and therefore will be associated with success, input and error by default. This might be overridden by another result file or an annotation.", new String[]{path});
                }
                if (!results.containsKey("success")) {
                    ResultConfig success = this.createResultConfig(actionClass, new ResultInfo("success", path, packageConfig, resultsByExtension), packageConfig, null);
                    results.put("success", success);
                }
                if (!results.containsKey("input")) {
                    ResultConfig input = this.createResultConfig(actionClass, new ResultInfo("input", path, packageConfig, resultsByExtension), packageConfig, null);
                    results.put("input", input);
                }
                if (!results.containsKey("error")) {
                    ResultConfig error = this.createResultConfig(actionClass, new ResultInfo("error", path, packageConfig, resultsByExtension), packageConfig, null);
                    results.put("error", error);
                }
            } else if (indexOfDot > resultPrefix.length()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The result file [#0] has a result code and therefore will be associated with only that result code.", new String[]{path});
                }
                String resultCode = path.substring(resultPrefix.length() + 1, indexOfDot);
                ResultConfig result = this.createResultConfig(actionClass, new ResultInfo(resultCode, path, packageConfig, resultsByExtension), packageConfig, null);
                results.put(resultCode, result);
            }
        }
    }

    protected void createFromAnnotations(Map<String, ResultConfig> resultConfigs, String resultPath, PackageConfig packageConfig, Result[] results, Class<?> actionClass, Map<String, ResultTypeConfig> resultsByExtension) {
        for (Result result : results) {
            ResultConfig config = this.createResultConfig(actionClass, new ResultInfo(result, packageConfig, resultPath, actionClass, resultsByExtension), packageConfig, result);
            if (config == null) continue;
            resultConfigs.put(config.getName(), config);
        }
    }

    protected ResultConfig createResultConfig(Class<?> actionClass, ResultInfo info, PackageConfig packageConfig, Result result) {
        String defaultParamName;
        ResultTypeConfig resultTypeConfig = (ResultTypeConfig)packageConfig.getAllResultTypeConfigs().get(info.type);
        if (resultTypeConfig == null) {
            throw new ConfigurationException("The Result type [" + info.type + "] which is" + " defined in the Result annotation on the class [" + actionClass + "] or determined" + " by the file extension or is the default result type for the PackageConfig of the" + " action, could not be found as a result-type defined for the Struts/XWork package [" + packageConfig.getName() + "]");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (resultTypeConfig.getParams() != null) {
            params.putAll(resultTypeConfig.getParams());
        }
        if (result != null) {
            params.putAll(StringTools.createParameterMap(result.params()));
        }
        if (info.location != null && !params.containsKey(defaultParamName = resultTypeConfig.getDefaultResultParam())) {
            params.put(defaultParamName, info.location);
        }
        return new ResultConfig.Builder(info.name, resultTypeConfig.getClassName()).addParams(params).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResultInfo {
        public final String name;
        public final String location;
        public final String type;

        public ResultInfo(String name, String location, PackageConfig packageConfig, Map<String, ResultTypeConfig> resultsByExtension) {
            this.name = name;
            this.location = location;
            this.type = this.determineType(location, packageConfig, resultsByExtension);
        }

        public ResultInfo(Result result, PackageConfig packageConfig, String resultPath, Class<?> actionClass, Map<String, ResultTypeConfig> resultsByExtension) {
            this.name = result.name();
            if (StringUtils.isNotBlank((String)result.type())) {
                this.type = result.type();
            } else if (StringUtils.isNotBlank((String)result.location())) {
                this.type = this.determineType(result.location(), packageConfig, resultsByExtension);
            } else {
                throw new ConfigurationException("The action class [" + actionClass + "] contains a " + "result annotation that has no type parameter and no location parameter. One of " + "these must be defined.");
            }
            this.location = StringUtils.isNotBlank((String)result.location()) ? (DefaultResultMapBuilder.this.relativeResultTypes.contains(this.type) && !result.location().startsWith("/") ? resultPath + result.location() : result.location()) : null;
        }

        String determineType(String location, PackageConfig packageConfig, Map<String, ResultTypeConfig> resultsByExtension) {
            int indexOfDot = location.lastIndexOf(".");
            if (indexOfDot > 0) {
                String extension = location.substring(indexOfDot + 1);
                ResultTypeConfig resultTypeConfig = resultsByExtension.get(extension);
                if (resultTypeConfig != null) {
                    return resultTypeConfig.getName();
                }
                throw new ConfigurationException("Unable to find a result type for extension [" + extension + "] " + "in location attribute [" + location + "].");
            }
            return packageConfig.getFullDefaultResultType();
        }
    }
}

