/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test.jsr286.event;

import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.StateAwareResponse;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.annotations.DefaultTestPhase;
import org.apache.pluto.testsuite.test.jsr286.event.BaseEventTest;
import org.apache.pluto.testsuite.test.jsr286.event.ComposedObject;

@DefaultTestPhase(value="EVENT_PHASE")
public class ComplexPayloadEventTest
extends BaseEventTest {
    public static final String TEST_COLOR = "red";
    public static final String TEST_POINT = "1, 1";
    public static final String COMPLEX_PAYLOAD_EVENT = "event-with-complex-value";

    protected void fireEvents(ActionRequest request, ActionResponse response) {
        ComposedObject payload = new ComposedObject(TEST_COLOR, TEST_POINT);
        response.setEvent(COMPLEX_PAYLOAD_EVENT, (Serializable)payload);
    }

    public TestResult checkExpectedEventWasFired(EventRequest request, EventResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setSpecPLT("15.2.2");
        result.setDescription("Check to make sure the the event-with-complex-value event was fired.");
        if (COMPLEX_PAYLOAD_EVENT.equals(request.getEvent().getName())) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Expected event name to be 'event-with-complex-value' but it was actually '" + request.getEvent().getName().getClass().getName() + "'");
        }
        return result;
    }

    public TestResult checkEventPayloadIsCorrectClass(EventRequest request, EventResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setSpecPLT("15.2.2");
        result.setDescription("Check to make sure that payload is an instanceof " + ComposedObject.class);
        Serializable value = request.getEvent().getValue();
        if (value == null) {
            result.setReturnCode(1);
            result.setResultMessage("Expected event payload type to be '" + ComposedObject.class.getName() + "' but it was null.");
        } else if (value instanceof ComposedObject) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Expected event payload type to be '" + ComposedObject.class.getName() + "' but it was actually '" + request.getEvent().getValue() + "'");
        }
        return result;
    }

    public TestResult checkEventPayloadIsCorrect(EventRequest request, EventResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setSpecPLT("15.2.2");
        result.setDescription("Check to make sure that the payload carries the proper state information from the event.");
        ComposedObject value = (ComposedObject)request.getEvent().getValue();
        if (!TEST_COLOR.equals(value.getColor())) {
            result.setReturnCode(1);
            result.setResultMessage("Expected payload color to be red but it was " + value.getColor());
        } else if (!TEST_POINT.equals(value.getPoint())) {
            result.setReturnCode(1);
            result.setResultMessage("Expected payload point to be 1, 1 but it was " + value.getPoint());
        } else {
            result.setReturnCode(2);
        }
        return result;
    }
}

