/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.apache.pluto.testsuite.test.ExpectedResults;

public class MiscTest
extends AbstractReflectivePortletTest {
    protected TestResult checkContextMajorVersion(PortletContext context) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the expected major version number is returned.");
        String majorVersion = String.valueOf(context.getMajorVersion());
        ExpectedResults expectedResults = ExpectedResults.getInstance();
        String expected = expectedResults.getMajorVersion();
        if (majorVersion != null && majorVersion.equals(expected)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"major version", (Object)majorVersion, (Object)expected, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkContextMinorVersion(PortletContext context) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the expected minor version number is returned.");
        String minorVersion = String.valueOf(context.getMinorVersion());
        ExpectedResults expectedResults = ExpectedResults.getInstance();
        String expected = expectedResults.getMinorVersion();
        if (minorVersion != null && minorVersion.equals(expected)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"minor version", (Object)minorVersion, (Object)expected, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkContextServerInfo(PortletContext context) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the expected server info is returned.");
        String serverInfo = context.getServerInfo();
        ExpectedResults expectedResults = ExpectedResults.getInstance();
        String expected = expectedResults.getServerInfo();
        if (serverInfo != null && serverInfo.equals(expected)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"server info", (Object)serverInfo, (Object)expected, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkPortalInfo(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the expected portal info is returned.");
        String portalInfo = request.getPortalContext().getPortalInfo();
        ExpectedResults expectedResults = ExpectedResults.getInstance();
        String expected = expectedResults.getPortalInfo();
        if (portalInfo != null && portalInfo.equals(expected)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"portal info", (Object)portalInfo, (Object)expected, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSupportedModes(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the expected portlet modes are returned.");
        ArrayList<PortletMode> requiredPortletModes = new ArrayList<PortletMode>();
        requiredPortletModes.add(PortletMode.VIEW);
        requiredPortletModes.add(PortletMode.EDIT);
        requiredPortletModes.add(PortletMode.HELP);
        Enumeration en = request.getPortalContext().getSupportedPortletModes();
        while (en.hasMoreElements()) {
            PortletMode portletMode = (PortletMode)en.nextElement();
            requiredPortletModes.remove(portletMode);
        }
        if (requiredPortletModes.isEmpty()) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            StringBuffer buffer = new StringBuffer();
            Iterator it = requiredPortletModes.iterator();
            while (it.hasNext()) {
                buffer.append(it.next()).append(", ");
            }
            result.setResultMessage("Required portlet modes [" + buffer.toString() + "] are not supported.");
        }
        return result;
    }

    protected TestResult checkSupportedWindowSates(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the expected window states are returned.");
        ArrayList<WindowState> requiredWindowStates = new ArrayList<WindowState>();
        requiredWindowStates.add(WindowState.MINIMIZED);
        requiredWindowStates.add(WindowState.MAXIMIZED);
        requiredWindowStates.add(WindowState.NORMAL);
        Enumeration en = request.getPortalContext().getSupportedWindowStates();
        while (en.hasMoreElements()) {
            WindowState windowState = (WindowState)en.nextElement();
            requiredWindowStates.remove(windowState);
        }
        if (requiredWindowStates.isEmpty()) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            StringBuffer buffer = new StringBuffer();
            Iterator it = requiredWindowStates.iterator();
            while (it.hasNext()) {
                buffer.append(it.next()).append(", ");
            }
            result.setResultMessage("Required window states [" + buffer.toString() + "] are not supported.");
        }
        return result;
    }
}

