/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.ContainerRuntimeOptionType;
import org.apache.pluto.container.om.portlet.impl.DescriptionType;
import org.apache.pluto.container.om.portlet.impl.DisplayNameType;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionReferenceType;
import org.apache.pluto.container.om.portlet.impl.InitParamType;
import org.apache.pluto.container.om.portlet.impl.PortletInfoType;
import org.apache.pluto.container.om.portlet.impl.PortletPreferencesType;
import org.apache.pluto.container.om.portlet.impl.SecurityRoleRefType;
import org.apache.pluto.container.om.portlet.impl.SupportsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="portletType", propOrder={"description", "portletName", "displayName", "portletClass", "initParam", "expirationCache", "cacheScope", "supports", "supportedLocale", "resourceBundle", "portletInfo", "portletPreferences", "securityRoleRef", "supportedProcessingEvent", "supportedPublishingEvent", "supportedPublicRenderParameter", "containerRuntimeOption"})
public class PortletType
implements PortletDefinition {
    @XmlElement(name="description")
    protected List<DescriptionType> description;
    @XmlElement(name="portlet-name", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String portletName;
    @XmlElement(name="display-name")
    protected List<DisplayNameType> displayName;
    @XmlElement(name="portlet-class", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String portletClass;
    @XmlElement(name="init-param")
    protected List<InitParamType> initParam;
    @XmlElement(name="expiration-cache")
    protected Integer expirationCache;
    @XmlElement(name="cache-scope")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String cacheScope;
    @XmlElement(required=true)
    protected List<SupportsType> supports;
    @XmlElement(name="supported-locale")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected List<String> supportedLocale;
    @XmlElement(name="resource-bundle")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String resourceBundle;
    @XmlElement(name="portlet-info")
    protected PortletInfoType portletInfo;
    @XmlElement(name="portlet-preferences")
    protected PortletPreferencesType portletPreferences;
    @XmlElement(name="security-role-ref")
    protected List<SecurityRoleRefType> securityRoleRef;
    @XmlElement(name="supported-processing-event")
    protected List<EventDefinitionReferenceType> supportedProcessingEvent;
    @XmlElement(name="supported-publishing-event")
    protected List<EventDefinitionReferenceType> supportedPublishingEvent;
    @XmlElement(name="supported-public-render-parameter")
    protected List<String> supportedPublicRenderParameter;
    @XmlElement(name="container-runtime-option")
    protected List<ContainerRuntimeOptionType> containerRuntimeOption;
    @XmlTransient
    private PortletApplicationDefinition application;

    public PortletApplicationDefinition getApplication() {
        return this.application;
    }

    public void setApplication(PortletApplicationDefinition app) {
        this.application = app;
    }

    public Description getDescription(Locale locale) {
        for (Description description : this.getDescriptions()) {
            if (!description.getLocale().equals(locale)) continue;
            return description;
        }
        return null;
    }

    public List<? extends Description> getDescriptions() {
        if (this.description == null) {
            this.description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    public Description addDescription(String lang) {
        DescriptionType d = new DescriptionType();
        d.setLang(lang);
        if (this.getDescription(d.getLocale()) != null) {
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.getDescriptions();
        this.description.add(d);
        return d;
    }

    public DisplayName getDisplayName(Locale locale) {
        for (DisplayName displayName : this.getDisplayNames()) {
            if (!displayName.getLocale().equals(locale)) continue;
            return displayName;
        }
        return null;
    }

    public List<? extends DisplayName> getDisplayNames() {
        if (this.displayName == null) {
            this.displayName = new ArrayList<DisplayNameType>();
        }
        return this.displayName;
    }

    public DisplayName addDisplayName(String lang) {
        DisplayNameType d = new DisplayNameType();
        d.setLang(lang);
        if (this.getDisplayName(d.getLocale()) != null) {
            throw new IllegalArgumentException("DisplayName for language: " + d.getLocale() + " already defined");
        }
        this.getDisplayNames();
        this.displayName.add(d);
        return d;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String value) {
        this.portletName = value;
    }

    public String getPortletClass() {
        return this.portletClass;
    }

    public void setPortletClass(String value) {
        this.portletClass = value;
    }

    public InitParam getInitParam(String name) {
        for (InitParam initParam : this.getInitParams()) {
            if (!initParam.getParamName().equals(name)) continue;
            return initParam;
        }
        return null;
    }

    public List<? extends InitParam> getInitParams() {
        if (this.initParam == null) {
            this.initParam = new ArrayList<InitParamType>();
        }
        return this.initParam;
    }

    public InitParam addInitParam(String paramName) {
        if (this.getInitParam(paramName) != null) {
            throw new IllegalArgumentException("Init parameter: " + paramName + " already defined");
        }
        InitParamType param = new InitParamType();
        param.setParamName(paramName);
        this.getInitParams();
        this.initParam.add(param);
        return param;
    }

    public int getExpirationCache() {
        return this.expirationCache != null ? this.expirationCache : 0;
    }

    public void setExpirationCache(int value) {
        this.expirationCache = new Integer(value);
    }

    public String getCacheScope() {
        return this.cacheScope != null ? this.cacheScope : "private";
    }

    public void setCacheScope(String cacheScope) {
        this.cacheScope = cacheScope;
    }

    public Supports getSupports(String mimeType) {
        for (Supports supports : this.getSupports()) {
            if (!supports.getMimeType().equals(mimeType)) continue;
            return supports;
        }
        return null;
    }

    public List<? extends Supports> getSupports() {
        if (this.supports == null) {
            this.supports = new ArrayList<SupportsType>();
        }
        return this.supports;
    }

    public Supports addSupports(String mimeType) {
        if (this.getSupports(mimeType) != null) {
            throw new IllegalArgumentException("Supports for mime type: " + mimeType + " already defined");
        }
        SupportsType s = new SupportsType();
        s.setMimeType(mimeType);
        this.supports.add(s);
        return s;
    }

    public List<String> getSupportedLocales() {
        if (this.supportedLocale == null) {
            this.supportedLocale = new ArrayList<String>();
        }
        return this.supportedLocale;
    }

    public void addSupportedLocale(String lang) {
        for (String l : this.getSupportedLocales()) {
            if (!l.equals(lang)) continue;
            throw new IllegalArgumentException("Supported locale: " + lang + " already defined");
        }
        this.supportedLocale.add(lang);
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String value) {
        this.resourceBundle = value;
    }

    public PortletInfo getPortletInfo() {
        if (this.portletInfo == null) {
            this.portletInfo = new PortletInfoType();
        }
        return this.portletInfo;
    }

    public Preferences getPortletPreferences() {
        if (this.portletPreferences == null) {
            this.portletPreferences = new PortletPreferencesType();
        }
        return this.portletPreferences;
    }

    public SecurityRoleRef getSecurityRoleRef(String roleName) {
        for (SecurityRoleRef securityRoleRef : this.getSecurityRoleRefs()) {
            if (!securityRoleRef.getRoleName().equals(roleName)) continue;
            return securityRoleRef;
        }
        return null;
    }

    public List<? extends SecurityRoleRef> getSecurityRoleRefs() {
        if (this.securityRoleRef == null) {
            this.securityRoleRef = new ArrayList<SecurityRoleRefType>();
        }
        return this.securityRoleRef;
    }

    public SecurityRoleRef addSecurityRoleRef(String roleName) {
        if (this.getSecurityRoleRef(roleName) != null) {
            throw new IllegalArgumentException("Security role reference for role: " + roleName + " already defined");
        }
        SecurityRoleRefType srr = new SecurityRoleRefType();
        srr.setRoleName(roleName);
        this.securityRoleRef.add(srr);
        return srr;
    }

    public List<? extends EventDefinitionReference> getSupportedProcessingEvents() {
        if (this.supportedProcessingEvent == null) {
            this.supportedProcessingEvent = new ArrayList<EventDefinitionReferenceType>();
        }
        return this.supportedProcessingEvent;
    }

    public EventDefinitionReference addSupportedProcessingEvent(QName qname) {
        this.getSupportedProcessingEvents();
        EventDefinitionReferenceType edr = new EventDefinitionReferenceType();
        edr.setQName(qname);
        this.supportedProcessingEvent.add(edr);
        return edr;
    }

    public EventDefinitionReference addSupportedProcessingEvent(String name) {
        this.getSupportedProcessingEvents();
        EventDefinitionReferenceType edr = new EventDefinitionReferenceType();
        edr.setName(name);
        this.supportedProcessingEvent.add(edr);
        return edr;
    }

    public List<? extends EventDefinitionReference> getSupportedPublishingEvents() {
        if (this.supportedPublishingEvent == null) {
            this.supportedPublishingEvent = new ArrayList<EventDefinitionReferenceType>();
        }
        return this.supportedPublishingEvent;
    }

    public EventDefinitionReference addSupportedPublishingEvent(QName qname) {
        this.getSupportedPublishingEvents();
        EventDefinitionReferenceType edr = new EventDefinitionReferenceType();
        edr.setQName(qname);
        this.supportedPublishingEvent.add(edr);
        return edr;
    }

    public EventDefinitionReference addSupportedPublishingEvent(String name) {
        this.getSupportedPublishingEvents();
        EventDefinitionReferenceType edr = new EventDefinitionReferenceType();
        edr.setName(name);
        this.supportedPublishingEvent.add(edr);
        return edr;
    }

    public List<String> getSupportedPublicRenderParameters() {
        if (this.supportedPublicRenderParameter == null) {
            this.supportedPublicRenderParameter = new ArrayList<String>();
        }
        return this.supportedPublicRenderParameter;
    }

    public void addSupportedPublicRenderParameter(String identifier) {
        for (String ident : this.getSupportedPublicRenderParameters()) {
            if (!ident.equals(identifier)) continue;
            throw new IllegalArgumentException("Support for public render parameter with identifier: " + identifier + " already defined");
        }
        this.supportedPublicRenderParameter.add(identifier);
    }

    public ContainerRuntimeOption getContainerRuntimeOption(String name) {
        for (ContainerRuntimeOption containerRuntimeOption : this.getContainerRuntimeOptions()) {
            if (!containerRuntimeOption.getName().equals(name)) continue;
            return containerRuntimeOption;
        }
        return null;
    }

    public List<? extends ContainerRuntimeOption> getContainerRuntimeOptions() {
        if (this.containerRuntimeOption == null) {
            this.containerRuntimeOption = new ArrayList<ContainerRuntimeOptionType>();
        }
        return this.containerRuntimeOption;
    }

    public ContainerRuntimeOption addContainerRuntimeOption(String name) {
        if (this.getContainerRuntimeOption(name) != null) {
            throw new IllegalArgumentException("Container runtime option with name: " + name + " already defined");
        }
        ContainerRuntimeOptionType cro = new ContainerRuntimeOptionType();
        cro.setName(name);
        this.containerRuntimeOption.add(cro);
        return cro;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.application = (PortletApplicationDefinition)parent;
    }
}

