/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class UpdateEmbeddedDoc {
    private XWPFDocument doc = null;
    private File docFile = null;
    private static final int SHEET_NUM = 0;
    private static final int ROW_NUM = 0;
    private static final int CELL_NUM = 0;
    private static final double NEW_VALUE = 100.98;
    private static final String BINARY_EXTENSION = "xls";
    private static final String OPENXML_EXTENSION = "xlsx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateEmbeddedDoc(String filename) throws FileNotFoundException, IOException {
        this.docFile = new File(filename);
        FileInputStream fis = null;
        if (!this.docFile.exists()) {
            throw new FileNotFoundException("The Word dcoument " + filename + " does not exist.");
        }
        try {
            fis = new FileInputStream(this.docFile);
            this.doc = new XWPFDocument((InputStream)fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException ioEx) {
                    System.out.println("IOException caught trying to close FileInputStream in the constructor of UpdateEmbeddedDoc.");
                }
            }
        }
    }

    public void updateEmbeddedDoc() throws OpenXML4JException, IOException {
        Workbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        PackagePart pPart2 = null;
        Iterator pIter = null;
        List embeddedDocs = this.doc.getAllEmbedds();
        if (embeddedDocs != null && !embeddedDocs.isEmpty()) {
            for (PackagePart pPart2 : embeddedDocs) {
                if (!pPart2.getPartName().getExtension().equals(BINARY_EXTENSION) && !pPart2.getPartName().getExtension().equals(OPENXML_EXTENSION)) continue;
                workbook = WorkbookFactory.create((InputStream)pPart2.getInputStream());
                sheet = workbook.getSheetAt(0);
                row = sheet.getRow(0);
                cell = row.getCell(0);
                cell.setCellValue(100.98);
                workbook.write(pPart2.getOutputStream());
            }
            this.doc.write((OutputStream)new FileOutputStream(this.docFile));
        }
    }

    public void checkUpdatedDoc() throws OpenXML4JException, IOException {
        Workbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        PackagePart pPart2 = null;
        Iterator pIter = null;
        List embeddedDocs = this.doc.getAllEmbedds();
        if (embeddedDocs != null && !embeddedDocs.isEmpty()) {
            for (PackagePart pPart2 : embeddedDocs) {
                if (!pPart2.getPartName().getExtension().equals(BINARY_EXTENSION) && !pPart2.getPartName().getExtension().equals(OPENXML_EXTENSION)) continue;
                workbook = WorkbookFactory.create((InputStream)pPart2.getInputStream());
                sheet = workbook.getSheetAt(0);
                row = sheet.getRow(0);
                cell = row.getCell(0);
                Assert.assertEquals((Object)cell.getNumericCellValue(), (Object)100.98);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UpdateEmbeddedDoc ued = new UpdateEmbeddedDoc(args[0]);
            ued.updateEmbeddedDoc();
            ued.checkUpdatedDoc();
        }
        catch (Exception ex) {
            System.out.println(ex.getClass().getName());
            System.out.println(ex.getMessage());
            ex.printStackTrace(System.out);
        }
    }
}

