/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.Properties;
import org.apache.openejb.client.RequestType;
import org.apache.openejb.loader.IO;

public class Stop {
    private static final String helpBase = "META-INF/org.apache.openejb.cli/";

    public static void stop(String host, int port) {
        try {
            Socket socket = new Socket(host, port);
            OutputStream out = socket.getOutputStream();
            out.write(RequestType.STOP_REQUEST_Stop.getCode());
        }
        catch (ConnectException e) {
            System.out.println(":: server not running ::");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        Stop.stop("localhost", 4200);
    }

    public static void main(String[] args) {
        try {
            String host = "localhost";
            int port = 4200;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    if (args.length <= i + 1) continue;
                    host = args[++i];
                    continue;
                }
                if (args[i].equals("-p")) {
                    if (args.length <= i + 1) continue;
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    Stop.printHelp();
                    return;
                }
                if (!args[i].equals("-examples")) continue;
                Stop.printExamples();
                return;
            }
            Stop.stop(host, port);
        }
        catch (Exception re) {
            System.err.println("[EJB Server] FATAL ERROR: " + re.getMessage());
            re.printStackTrace();
        }
    }

    private static void printHelp() {
        String header = "OpenEJB Remote Server ";
        try {
            Properties versionInfo = Stop.loadVersionProperties();
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResource("META-INF/org.apache.openejb.cli/stop.help").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printExamples() {
        String header = "OpenEJB Remote Server ";
        try {
            Properties versionInfo = Stop.loadVersionProperties();
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResource("META-INF/org.apache.openejb.cli/stop.examples").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Properties loadVersionProperties() throws IOException {
        return IO.readProperties((URL)new URL("resource:/openejb-version.properties"));
    }
}

