/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import javassist.util.proxy.ProxyObjectOutputStream;
import javax.enterprise.inject.spi.Bean;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.failover.FailOverBagWrapper;
import org.apache.webbeans.web.failover.OwbProxyObjectInputStream;
import org.apache.webbeans.web.failover.SerializationHandlerV10;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOwbFailOverService
implements FailOverService {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(DefaultOwbFailOverService.class);
    private static final String OWB_FAILOVER_JVM_ID = UUID.randomUUID().toString() + "_" + String.valueOf(System.currentTimeMillis());
    private static final String OWB_FAILOVER_PROPERTY_NAME = "org.apache.webbeans.web.failover";
    private static final String OWB_FAILOVER_IS_SUPPORT_FAILOVER = "org.apache.webbeans.web.failover.issupportfailover";
    private static final String OWB_FAILOVER_IS_SUPPORT_PASSIVATE = "org.apache.webbeans.web.failover.issupportpassivation";
    private static final String OWB_FAILOVER_RESOURCSES_SERIALIZATION_HANDLER = "org.apache.webbeans.web.failover.resources.serialization.handler.v10";
    boolean isSupportFailOver;
    boolean isSupportPassivation;
    SerializationHandlerV10 handler;
    ThreadLocal<Boolean> isForPassivation = new ThreadLocal();

    public DefaultOwbFailOverService() {
        String value = WebBeansContext.getInstance().getOpenWebBeansConfiguration().getProperty(OWB_FAILOVER_IS_SUPPORT_FAILOVER);
        if (value != null && value.equalsIgnoreCase("true")) {
            this.isSupportFailOver = true;
        }
        if ((value = WebBeansContext.getInstance().getOpenWebBeansConfiguration().getProperty(OWB_FAILOVER_IS_SUPPORT_PASSIVATE)) != null && value.equalsIgnoreCase("true")) {
            this.isSupportPassivation = true;
        }
        if (this.isSupportFailOver || this.isSupportPassivation) {
            WebBeansUtil.initProxyFactoryClassLoaderProvider();
            value = WebBeansContext.getInstance().getOpenWebBeansConfiguration().getProperty(OWB_FAILOVER_RESOURCSES_SERIALIZATION_HANDLER);
            try {
                if (value != null) {
                    this.handler = (SerializationHandlerV10)Class.forName(value).newInstance();
                }
            }
            catch (Exception e) {
                logger.error("DefaultOwbFailOverService could not instanciate: [{0}]", e, value);
            }
        }
        if (logger.wblWillLogDebug()) {
            logger.debug("DefaultOwbFailOverService isSupportFailOver: [{0}]", String.valueOf(this.isSupportFailOver));
            logger.debug("DefaultOwbFailOverService isSupportPassivation: [{0}]", String.valueOf(this.isSupportPassivation));
        }
    }

    @Override
    public String getJVMId() {
        return OWB_FAILOVER_JVM_ID;
    }

    @Override
    public String getFailOverAttributeName() {
        return OWB_FAILOVER_PROPERTY_NAME;
    }

    @Override
    public void sessionIsIdle(HttpSession session) {
        if (session != null) {
            FailOverBagWrapper bagWrapper = (FailOverBagWrapper)session.getAttribute(this.getFailOverAttributeName());
            if (bagWrapper == null) {
                bagWrapper = new FailOverBagWrapper(session, this);
            } else {
                bagWrapper.updateOwbFailOverBag(session, this);
            }
            session.setAttribute(this.getFailOverAttributeName(), bagWrapper);
        }
        this.isForPassivation.remove();
        this.isForPassivation.set(null);
    }

    @Override
    public void sessionIsInUse(HttpSession session) {
        FailOverBagWrapper bagWrapper;
        if (session != null && (bagWrapper = (FailOverBagWrapper)session.getAttribute(this.getFailOverAttributeName())) != null) {
            bagWrapper.sessionIsInUse();
        }
    }

    @Override
    public void sessionWillPassivate(HttpSession session) {
        FailOverBagWrapper bagWrapper = new FailOverBagWrapper(session, this);
        session.setAttribute(this.getFailOverAttributeName(), bagWrapper);
        this.isForPassivation.set(Boolean.TRUE);
    }

    @Override
    public void restoreBeans(HttpSession session) {
        FailOverBagWrapper bagWrapper = (FailOverBagWrapper)session.getAttribute(this.getFailOverAttributeName());
        if (bagWrapper != null) {
            if (logger.wblWillLogDebug()) {
                logger.debug("DefaultOwbFailOverService restoreBeans for session: [{0}]", session);
            }
            bagWrapper.restore();
            session.removeAttribute(this.getFailOverAttributeName());
        }
    }

    @Override
    public boolean isSupportFailOver() {
        return this.isSupportFailOver;
    }

    @Override
    public boolean isSupportPassivation() {
        return this.isSupportPassivation;
    }

    @Override
    public void enableFailOverSupport(boolean flag) {
        this.isSupportFailOver = flag;
    }

    @Override
    public void enablePassivationSupport(boolean flag) {
        this.isSupportPassivation = flag;
    }

    @Override
    public ObjectInputStream getObjectInputStream(InputStream in) throws IOException {
        return new OwbProxyObjectInputStream(in);
    }

    @Override
    public ObjectOutputStream getObjectOutputStream(OutputStream out) throws IOException {
        return new ProxyObjectOutputStream(out);
    }

    @Override
    public Object handleResource(Bean<?> bean, Object resourceObject, ObjectInput in, ObjectOutput out) {
        if (this.handler != null) {
            return this.handler.handleResource(bean, resourceObject, in, out, Boolean.TRUE == this.isForPassivation.get() ? 1 : 0);
        }
        return NOT_HANDLED;
    }
}

