/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionLoader {
    private final Map<Bean<?>, Object> extensions = new ConcurrentHashMap();
    private final Set<Class<? extends Extension>> extensionClasses = new HashSet<Class<? extends Extension>>();
    private final BeanManagerImpl manager;
    private final WebBeansContext webBeansContext;

    public ExtensionLoader(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.manager = this.webBeansContext.getBeanManagerImpl();
    }

    @Deprecated
    public static ExtensionLoader getInstance() {
        return WebBeansContext.getInstance().getExtensionLoader();
    }

    public void loadExtensionServices() {
        this.loadExtensionServices(WebBeansUtil.getCurrentClassLoader());
    }

    public void loadExtensionServices(ClassLoader classLoader) {
        List<Extension> loader = this.webBeansContext.getLoaderService().load(Extension.class, classLoader);
        for (Extension extension : loader) {
            if (this.extensionClasses.contains(extension.getClass())) continue;
            this.extensionClasses.add(extension.getClass());
            try {
                this.addExtension(extension);
            }
            catch (Exception e) {
                throw new WebBeansException("Error occurred while reading Extension service list", e);
            }
        }
    }

    public <T> T getBeanInstance(Bean<T> bean) {
        Asserts.assertNotNull(bean, "bean parameter cannot be null");
        if (this.extensions.containsKey(bean)) {
            return (T)this.extensions.get(bean);
        }
        return null;
    }

    public void addExtension(Extension ext) {
        ExtensionBean<?> bean = this.webBeansContext.getWebBeansUtil().createExtensionComponent(ext.getClass());
        this.extensions.put(bean, ext);
        this.manager.addBean(bean);
    }

    public void clear() {
        this.extensions.clear();
        this.extensionClasses.clear();
    }
}

