/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InterceptorHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorHandler.class);
    protected OwbBean<?> bean = null;
    protected volatile transient Map<Method, List<InterceptorData>> interceptedMethodMap = null;
    protected WebBeansContext webBeansContext;

    protected InterceptorHandler(OwbBean<?> bean) {
        this.bean = bean;
        this.webBeansContext = bean.getWebBeansContext();
    }

    protected boolean isNotInterceptedOrDecoratedMethod(Method method) {
        return false;
    }

    protected void setNotInterceptedOrDecoratedMethod(Method method) {
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments, CreationalContextImpl<?> ownerCreationalContext) throws Exception {
        if (instance == null) {
            return null;
        }
        Object result = null;
        try {
            boolean isNotInterceptedOrDecoratedMethod = this.isNotInterceptedOrDecoratedMethod(method);
            String methodName = method.getName();
            if (!isNotInterceptedOrDecoratedMethod && !ClassUtil.isObjectMethod(methodName) && this.bean instanceof InjectionTargetBean) {
                InjectionTargetBean injectionTarget = (InjectionTargetBean)this.bean;
                DelegateHandler delegateHandler = null;
                InterceptorDataImpl decoratorInterceptorDataImpl = null;
                if (this.webBeansContext.getInterceptorUtil().isWebBeansBusinessMethod(method)) {
                    List<InterceptorData> interceptorStack;
                    List<Object> decorators = null;
                    if (!injectionTarget.getDecoratorStack().isEmpty()) {
                        Class<?> proxyClass = this.webBeansContext.getJavassistProxyFactory().getInterceptorProxyClasses().get(this.bean);
                        if (proxyClass == null) {
                            ProxyFactory delegateFactory = this.webBeansContext.getJavassistProxyFactory().createProxyFactory(this.bean);
                            proxyClass = this.webBeansContext.getJavassistProxyFactory().getProxyClass(delegateFactory);
                            this.webBeansContext.getJavassistProxyFactory().getInterceptorProxyClasses().put(this.bean, proxyClass);
                        }
                        Object delegate = proxyClass.newInstance();
                        delegateHandler = new DelegateHandler(this.bean);
                        ((ProxyObject)delegate).setHandler(delegateHandler);
                        decorators = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, instance, delegate, ownerCreationalContext);
                        delegateHandler.setDecorators(decorators);
                    }
                    if (!(interceptorStack = injectionTarget.getInterceptorStack()).isEmpty()) {
                        List<InterceptorData> interceptorMethods;
                        if (this.interceptedMethodMap == null) {
                            this.interceptedMethodMap = new ConcurrentHashMap<Method, List<InterceptorData>>();
                        }
                        if (decorators != null) {
                            WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(delegateHandler, instance);
                            decoratorInterceptorDataImpl = new InterceptorDataImpl(true, lastInterceptor, this.webBeansContext);
                            decoratorInterceptorDataImpl.setDefinedInInterceptorClass(true);
                            decoratorInterceptorDataImpl.setAroundInvoke(this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(lastInterceptor.getClass(), "invokeDecorators", InvocationContext.class));
                        }
                        if ((interceptorMethods = this.interceptedMethodMap.get(method)) == null) {
                            ArrayList<InterceptorData> filteredInterceptorStack = new ArrayList<InterceptorData>();
                            for (InterceptorData interceptData : interceptorStack) {
                                if (interceptData.getAroundInvoke() == null) continue;
                                filteredInterceptorStack.add(interceptData);
                            }
                            InterceptorUtil interceptorUtil = this.webBeansContext.getInterceptorUtil();
                            interceptorUtil.filterCommonInterceptorStackList(filteredInterceptorStack, method);
                            interceptorUtil.filterOverridenAroundInvokeInterceptor(this.bean.getBeanClass(), filteredInterceptorStack);
                            this.interceptedMethodMap.put(method, filteredInterceptorStack);
                            interceptorMethods = filteredInterceptorStack;
                        }
                        if (decoratorInterceptorDataImpl != null) {
                            interceptorMethods = new ArrayList<InterceptorData>(interceptorMethods);
                            interceptorMethods.add(decoratorInterceptorDataImpl);
                        }
                        if (!interceptorMethods.isEmpty()) {
                            return this.callAroundInvokes(method, arguments, interceptorMethods);
                        }
                    }
                    if (decorators != null) {
                        return delegateHandler.invoke(instance, method, proceed, arguments);
                    }
                }
                this.setNotInterceptedOrDecoratedMethod(method);
            }
            if (!method.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible(method, true);
            }
            result = method.invoke(instance, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getCause();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            throw e;
        }
        return result;
    }

    protected abstract Object callAroundInvokes(Method var1, Object[] var2, List<InterceptorData> var3) throws Exception;

    protected BeanManagerImpl getBeanManager() {
        return this.webBeansContext.getBeanManagerImpl();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeLong(1L);
        String passivationId = this.bean.getId();
        if (passivationId != null) {
            s.writeObject(passivationId);
        } else {
            s.writeObject(null);
            this.logger.warn("WARN_0010", this.bean);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (s.readLong() == 1L) {
            this.webBeansContext = WebBeansContext.currentInstance();
            String passivationId = (String)s.readObject();
            if (passivationId != null) {
                this.bean = (OwbBean)this.webBeansContext.getBeanManagerImpl().getPassivationCapableBean(passivationId);
            }
        } else {
            this.logger.warn("WARN_0011", this.bean);
        }
    }
}

