/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.instance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.OwbCustomObjectInputStream;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstanceImpl<T>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -8401944412490389024L;
    private Type injectionClazz;
    private Class<?> injectionPointClazz;
    private Set<Annotation> qualifierAnnotations = new HashSet<Annotation>();
    private WebBeansContext webBeansContext;
    private CreationalContext<?> parentCreationalContext;
    private Object ownerInstance;

    InstanceImpl(Type injectionClazz, Class<?> injectionPointClazz, WebBeansContext webBeansContext, CreationalContext<?> creationalContext, Object ownerInstance, Annotation ... annotations) {
        this.injectionClazz = injectionClazz;
        this.injectionPointClazz = injectionPointClazz;
        this.parentCreationalContext = creationalContext;
        this.ownerInstance = ownerInstance;
        for (Annotation ann : annotations) {
            this.qualifierAnnotations.add(ann);
        }
        this.webBeansContext = webBeansContext;
    }

    @Override
    public T get() {
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        Set beans = this.resolveBeans();
        this.webBeansContext.getResolutionUtil().checkResolvedBeans(beans, ClassUtil.getClazz(this.injectionClazz), anns);
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        Bean bean = beanManager.resolve(beans);
        CreationalContext<Object> creationalContext = this.parentCreationalContext;
        boolean isDependentBean = WebBeansUtil.isDependent(bean);
        if (!isDependentBean) {
            creationalContext = beanManager.createCreationalContext(bean);
        }
        Object instance = beanManager.getReference(bean, null, creationalContext);
        if (isDependentBean && this.ownerInstance != null && creationalContext instanceof CreationalContextImpl) {
            ((CreationalContextImpl)creationalContext).addDependent(this.ownerInstance, bean, instance);
        }
        return (T)instance;
    }

    private Set<Bean<?>> resolveBeans() {
        InjectionResolver injectionResolver;
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        InjectionResolver resolver = injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Set<Bean<?>> beans = resolver.implResolveByType(this.injectionClazz, this.injectionPointClazz, anns);
        return beans;
    }

    @Override
    public boolean isAmbiguous() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() > 1;
    }

    @Override
    public boolean isUnsatisfied() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() == 0;
    }

    @Override
    public Instance<T> select(Annotation ... qualifiers) {
        Annotation[] newQualifiersArray = this.getAdditionalQualifiers(qualifiers);
        InstanceImpl<T> newInstance = new InstanceImpl<T>(this.injectionClazz, this.injectionPointClazz, this.webBeansContext, this.parentCreationalContext, this.ownerInstance, newQualifiersArray);
        return newInstance;
    }

    private Annotation[] getAdditionalQualifiers(Annotation[] qualifiers) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifierAnnotations);
        if (qualifiers != null && qualifiers.length > 0) {
            for (Annotation annot : qualifiers) {
                if (newQualifiers.contains(annot)) {
                    throw new IllegalArgumentException("Duplicate Qualifier Exception, " + this.toString());
                }
                newQualifiers.add(annot);
            }
        }
        Annotation[] newQualifiersArray = new Annotation[newQualifiers.size()];
        newQualifiersArray = newQualifiers.toArray(newQualifiersArray);
        return newQualifiersArray;
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        Type sub = subtype;
        if (sub == null) {
            sub = this.injectionClazz;
        }
        Annotation[] newQualifiers = this.getAdditionalQualifiers(qualifiers);
        InstanceImpl<T> newInstance = new InstanceImpl<T>(sub, this.injectionPointClazz, this.webBeansContext, this.parentCreationalContext, this.ownerInstance, newQualifiers);
        return newInstance;
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.select(subtype.getRawType(), qualifiers);
    }

    @Override
    public Iterator<T> iterator() {
        Set<Bean<?>> beans = this.resolveBeans();
        HashSet instances = new HashSet();
        for (Bean<?> bean : beans) {
            Object instance = this.webBeansContext.getBeanManagerImpl().getInstance(bean, null);
            instances.add(instance);
        }
        return instances.iterator();
    }

    private void writeObject(ObjectOutputStream op) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(op);
        oos.writeObject(this.injectionClazz);
        oos.writeObject(this.qualifierAnnotations);
        oos.writeObject(this.injectionPointClazz);
        oos.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.webBeansContext = WebBeansContext.currentInstance();
        OwbCustomObjectInputStream inputStream = new OwbCustomObjectInputStream(in, WebBeansUtil.getCurrentClassLoader());
        this.injectionClazz = (Type)inputStream.readObject();
        this.qualifierAnnotations = (Set)inputStream.readObject();
        this.injectionPointClazz = (Class)inputStream.readObject();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Instance<");
        builder.append(ClassUtil.getClazz(this.injectionClazz).getName());
        builder.append("> injectionPointClazz=").append(this.injectionPointClazz);
        builder.append(",with qualifier annotations {");
        boolean i = false;
        for (Annotation qualifier : this.qualifierAnnotations) {
            if (i) {
                builder.append(",");
            }
            builder.append(((Object)qualifier).toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

