/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.interceptor.Interceptor;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbValidator {
    private EjbValidator() {
    }

    public static void validateEjbScopeType(BaseEjbBean<?> ejbBean) {
        Asserts.assertNotNull(ejbBean, "Session Bean can not be null");
        if (ejbBean.getScope() == null) {
            throw new NullPointerException("Session Bean scope can not be null");
        }
        if (ejbBean.getEjbType() == null) {
            throw new NullPointerException("Session Bean type can not be null. It must be one of @Stateless, @Stateful, @Singleton");
        }
        if (ejbBean.getEjbType().equals((Object)SessionBeanType.STATELESS)) {
            if (!ejbBean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Stateless Session Bean class : " + ejbBean.getReturnType() + " " + "can not define scope other than @Dependent");
            }
        } else if (ejbBean.getEjbType().equals((Object)SessionBeanType.SINGLETON) && !ejbBean.getScope().equals(Dependent.class) && !ejbBean.getScope().equals(ApplicationScoped.class)) {
            throw new WebBeansConfigurationException("Singleton Session Bean class : " + ejbBean.getReturnType() + " " + "can not define scope other than @Dependent or @ApplicationScoped");
        }
    }

    public static void validateDecoratorOrInterceptor(Class<?> ejbClass) {
        Asserts.assertNotNull(ejbClass, "ejbClass parameter can not be null");
        if (AnnotationUtil.hasClassAnnotation(ejbClass, Decorator.class)) {
            throw new WebBeansConfigurationException("Ejb WebBeans Component with implementation class : " + ejbClass.getName() + " can not annotated with @Decorator");
        }
        if (AnnotationUtil.hasClassAnnotation(ejbClass, Interceptor.class)) {
            throw new WebBeansConfigurationException("Ejb WebBeans Component with implementation class : " + ejbClass.getName() + " can not annotated with @Interceptor");
        }
    }

    public static void validateGenericBeanType(Class<?> ejbClass, Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(ejbClass, "ejbClass parameter can not be null");
        Asserts.assertNotNull(ejbClass, "scopeType parameter can not be null");
        if (ClassUtil.isDefinitionContainsTypeVariables(ejbClass) && !scopeType.equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Ejb generic bean class : " + ejbClass.getName() + "scope must be @Dependent");
        }
    }

    public static void validateObserverMethods(BaseEjbBean<?> bean, Set<ObserverMethod<?>> observers) {
        for (ObserverMethod<?> observer : observers) {
            ObserverMethodImpl obs = (ObserverMethodImpl)observer;
            Method method = obs.getObserverMethod();
            List<Class<?>> locals = bean.getBusinessLocalInterfaces();
            if (locals == null) continue;
            Iterator<Class<?>> it = locals.iterator();
            boolean found = false;
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                List<Method> methods = ClassUtil.getClassMethodsWithTypes(clazz, method.getName(), Arrays.asList(method.getParameterTypes()));
                if (methods.isEmpty()) continue;
                obs.setObserverMethod(methods.get(0));
                found = true;
                break;
            }
            if (found || Modifier.isStatic(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("Observer method : " + method.getName() + " in session bean class : " + bean.getBeanClass() + " must be business method");
        }
    }
}

