/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.xbean.asm.ClassWriter;
import org.apache.xbean.asm.Label;
import org.apache.xbean.asm.MethodVisitor;
import org.apache.xbean.asm.Opcodes;
import org.apache.xbean.asm.Type;

public class MakeTxLookup
implements Opcodes {
    public static final String HIBERNATE_FACTORY = "org.apache.openejb.hibernate.TransactionManagerLookup";
    public static final String HIBERNATE_NEW_FACTORY = "org.apache.openejb.hibernate.OpenEJBJtaPlatform";
    public static final String TOPLINK_FACTORY = "org.apache.openejb.toplink.JTATransactionController";
    public static final String ECLIPSELINK_FACTORY = "org.apache.openejb.eclipselink.JTATransactionController";

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        MakeTxLookup.createHibernteStrategy(file);
        MakeTxLookup.createNewHibernateStrategy(file);
        MakeTxLookup.createTopLinkStrategy(file);
        MakeTxLookup.createEclipseLinkStrategy(file);
    }

    private static void createNewHibernateStrategy(File basedir) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, "org/apache/openejb/hibernate/OpenEJBJtaPlatform", null, "org/hibernate/service/jta/platform/internal/AbstractJtaPlatform", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/hibernate/service/jta/platform/internal/AbstractJtaPlatform", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "locateTransactionManager", "()Ljavax/transaction/TransactionManager;", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "locateUserTransaction", "()Ljavax/transaction/UserTransaction;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "javax/naming/NamingException");
        mv.visitLabel(l0);
        mv.visitMethodInsn(184, "org/apache/openejb/loader/SystemInstance", "get", "()Lorg/apache/openejb/loader/SystemInstance;");
        mv.visitLdcInsn(Type.getType("Lorg/apache/openejb/spi/ContainerSystem;"));
        mv.visitMethodInsn(182, "org/apache/openejb/loader/SystemInstance", "getComponent", "(Ljava/lang/Class;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "org/apache/openejb/spi/ContainerSystem");
        mv.visitMethodInsn(185, "org/apache/openejb/spi/ContainerSystem", "getJNDIContext", "()Ljavax/naming/Context;");
        mv.visitLdcInsn("comp/UserTransaction");
        mv.visitMethodInsn(185, "javax/naming/Context", "lookup", "(Ljava/lang/String;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "javax/transaction/UserTransaction");
        mv.visitLabel(l1);
        mv.visitInsn(176);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"javax/naming/NamingException"});
        mv.visitVarInsn(58, 1);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        String factory = HIBERNATE_NEW_FACTORY;
        String classFilePath = factory.replace('.', '/');
        MakeTxLookup.write(basedir, cw, classFilePath);
    }

    private static void createHibernteStrategy(File baseDir) throws Exception {
        String factory = HIBERNATE_FACTORY;
        String classFilePath = factory.replace('.', '/');
        String sourceFileName = factory.substring(factory.lastIndexOf(46) + 1, factory.length()) + ".java";
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, classFilePath, null, "java/lang/Object", new String[]{"org/hibernate/transaction/TransactionManagerLookup"});
        cw.visitSource(sourceFileName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTransactionManager", "(Ljava/util/Properties;)Ljavax/transaction/TransactionManager;", null, new String[]{"org/hibernate/HibernateException"});
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getUserTransactionName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn("java:comp/UserTransaction");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTransactionIdentifier", "(Ljavax/transaction/Transaction;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        cw.visitEnd();
        MakeTxLookup.write(baseDir, cw, classFilePath);
    }

    private static void createTopLinkStrategy(File baseDir) throws Exception {
        String factory = TOPLINK_FACTORY;
        String classFilePath = factory.replace('.', '/');
        String sourceFileName = factory.substring(factory.lastIndexOf(46) + 1, factory.length()) + ".java";
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, classFilePath, null, "oracle/toplink/essentials/transaction/JTATransactionController", null);
        cw.visitSource(sourceFileName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "oracle/toplink/essentials/transaction/JTATransactionController", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "acquireTransactionManager", "()Ljavax/transaction/TransactionManager;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        MakeTxLookup.write(baseDir, cw, classFilePath);
    }

    private static void createEclipseLinkStrategy(File baseDir) throws Exception {
        String factory = ECLIPSELINK_FACTORY;
        String classFilePath = factory.replace('.', '/');
        String sourceFileName = factory.substring(factory.lastIndexOf(46) + 1, factory.length()) + ".java";
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, classFilePath, null, "org/eclipse/persistence/transaction/JTATransactionController", null);
        cw.visitSource(sourceFileName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/eclipse/persistence/transaction/JTATransactionController", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "acquireTransactionManager", "()Ljavax/transaction/TransactionManager;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        MakeTxLookup.write(baseDir, cw, classFilePath);
    }

    private static void write(File file, ClassWriter cw, String classFileName) throws IOException {
        classFileName = "classes/" + classFileName + ".class";
        for (String part : classFileName.split("/")) {
            file = new File(file, part);
        }
        file.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        out.write(cw.toByteArray());
        out.close();
    }
}

