/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.quartz;

import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.openejb.resource.quartz.JobSpec;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzResourceAdapter
implements ResourceAdapter {
    private static Exception ex = null;
    private Scheduler scheduler;
    private BootstrapContext bootstrapContext;
    private Thread startThread;

    @Override
    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        this.startThread = new Thread("Quartz Scheduler Start"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                QuartzResourceAdapter quartzResourceAdapter = QuartzResourceAdapter.this;
                synchronized (quartzResourceAdapter) {
                    try {
                        QuartzResourceAdapter.this.scheduler = StdSchedulerFactory.getDefaultScheduler();
                    }
                    catch (Exception e) {
                        ex = e;
                        return;
                    }
                }
                try {
                    QuartzResourceAdapter.this.scheduler.start();
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        };
        this.startThread.setDaemon(true);
        this.startThread.start();
        try {
            this.startThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (null != ex) {
            throw new ResourceAdapterInternalException("Failed to create Quartz Scheduler", ex);
        }
        Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").info("Started Quartz Scheduler");
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        QuartzResourceAdapter quartzResourceAdapter = this;
        synchronized (quartzResourceAdapter) {
            if (null != this.scheduler) {
                if (this.startThread.isAlive()) {
                    this.startThread.interrupt();
                }
                Thread stopThread = new Thread("Quartz Scheduler Requested Stop"){

                    @Override
                    public void run() {
                        try {
                            QuartzResourceAdapter.this.scheduler.shutdown(true);
                        }
                        catch (Exception e) {
                            ex = e;
                        }
                    }
                };
                stopThread.setDaemon(true);
                stopThread.start();
                try {
                    stopThread.join(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                try {
                    if (!this.scheduler.isShutdown()) {
                        stopThread = new Thread("Quartz Scheduler Forced Stop"){

                            @Override
                            public void run() {
                                try {
                                    QuartzResourceAdapter.this.scheduler.shutdown(false);
                                    Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").warning("Forced Quartz stop - Jobs may be incomplete");
                                }
                                catch (Exception e) {
                                    ex = e;
                                }
                            }
                        };
                        stopThread.setDaemon(true);
                        stopThread.start();
                    }
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        }
        this.bootstrapContext = null;
        if (null != ex) {
            Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").warning("Error stopping Quartz Scheduler", ex);
            return;
        }
        Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").info("Stopped Quartz Scheduler");
    }

    @Override
    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        if (null == this.scheduler) {
            throw new ResourceException("Quartz Scheduler is not available");
        }
        try {
            JobSpec spec = (JobSpec)activationSpec;
            MessageEndpoint endpoint = messageEndpointFactory.createEndpoint(null);
            spec.setEndpoint(endpoint);
            Job job = (Job)((Object)endpoint);
            JobDataMap jobDataMap = spec.getDetail().getJobDataMap();
            jobDataMap.setAllowsTransientData(true);
            jobDataMap.put((Object)Data.class.getName(), new Data(job));
            this.scheduler.scheduleJob(spec.getDetail(), spec.getTrigger());
        }
        catch (SchedulerException e) {
            throw new ResourceException("Failed to schedule job", e);
        }
    }

    @Override
    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        if (null == this.scheduler) {
            throw new IllegalStateException("Quartz Scheduler is not available");
        }
        JobSpec spec = null;
        try {
            spec = (JobSpec)activationSpec;
            this.scheduler.deleteJob(spec.getJobName(), spec.getJobGroup());
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Failed to delete job", e);
        }
        finally {
            if (null != spec) {
                spec.getEndpoint().release();
            }
        }
    }

    @Override
    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        return new XAResource[0];
    }

    private static class Data {
        private final Job job;

        private Data(Job job) {
            this.job = job;
        }
    }

    public static class JobEndpoint
    implements Job {
        private static Method method = null;

        @Override
        public void execute(JobExecutionContext execution) throws JobExecutionException {
            MessageEndpoint endpoint = null;
            try {
                JobDataMap jobDataMap = execution.getJobDetail().getJobDataMap();
                Data data = (Data)Data.class.cast(jobDataMap.get(Data.class.getName()));
                Job job = data.job;
                endpoint = (MessageEndpoint)((Object)job);
                if (null == method) {
                    method = Job.class.getMethod("execute", JobExecutionContext.class);
                }
                endpoint.beforeDelivery(method);
                job.execute(execution);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (ResourceException e) {
                throw new JobExecutionException(e);
            }
            catch (Throwable t) {
                throw new JobExecutionException(new Exception(t));
            }
            finally {
                if (null != endpoint) {
                    try {
                        endpoint.afterDelivery();
                    }
                    catch (ResourceException e) {
                        throw new JobExecutionException(e);
                    }
                }
            }
        }
    }
}

