/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.quartz;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpoint;
import org.apache.openejb.resource.quartz.QuartzResourceAdapter;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

public final class JobSpec
implements ActivationSpec {
    private MessageEndpoint endpoint;
    private ResourceAdapter resourceAdapter;
    private final CronTrigger trigger;
    private final JobDetail detail;
    private InvalidPropertyException invalidProperty;

    public JobSpec() {
        int i = this.hashCode();
        this.detail = new JobDetail();
        this.trigger = new CronTrigger();
        this.detail.setJobClass(QuartzResourceAdapter.JobEndpoint.class);
        this.detail.getJobDataMap().setAllowsTransientData(true);
        this.setVolatile(true);
        this.setJobGroup("DEFAULT");
        this.setJobName("Job" + i);
        this.setTriggerGroup("DEFAULT");
        this.setTriggerName("Trigger" + i);
    }

    public String getTriggerName() {
        return this.trigger.getName();
    }

    public void setTriggerName(String s) {
        this.trigger.setName(s);
    }

    public String getTriggerGroup() {
        return this.trigger.getGroup();
    }

    public void setTriggerGroup(String s) {
        this.trigger.setGroup(s);
    }

    public String getJobName() {
        return this.detail.getName();
    }

    public void setJobName(String s) {
        this.detail.setName(s);
        this.trigger.setJobName(s);
    }

    public void setJobGroup(String s) {
        this.detail.setGroup(s);
        this.trigger.setJobGroup(s);
    }

    public String getJobGroup() {
        return this.trigger.getJobGroup();
    }

    public String getDescription() {
        return this.trigger.getDescription();
    }

    public void setDescription(String s) {
        this.detail.setDescription(s);
        this.trigger.setDescription(s);
    }

    public void setVolatile(boolean b) {
        this.detail.setVolatility(b);
        this.trigger.setVolatility(b);
    }

    public boolean isVolatile() {
        return this.trigger.isVolatile();
    }

    public void setRequestsRecovery(boolean b) {
        this.detail.setRequestsRecovery(b);
    }

    public boolean isRequestsRecovery() {
        return this.detail.requestsRecovery();
    }

    public boolean isDurable() {
        return this.detail.isDurable();
    }

    public void setDurable(boolean b) {
        this.detail.setDurability(b);
    }

    public void setCalendarName(String s) {
        this.trigger.setCalendarName(s);
    }

    public String getCalendarName() {
        return this.trigger.getCalendarName();
    }

    public void setCronExpression(String s) {
        try {
            this.trigger.setCronExpression(s);
        }
        catch (ParseException e) {
            this.invalidProperty = new InvalidPropertyException("Invalid cron expression " + s, e);
        }
    }

    public String getCronExpression() {
        return this.trigger.getCronExpression();
    }

    public void setCronTrigger(String s) {
        this.setCronExpression(s);
    }

    public void setTimeZone(String timeZone) {
        this.trigger.setTimeZone(TimeZone.getTimeZone(timeZone));
    }

    public void setStartTime(String startTime) {
        Date date = this.parse(startTime);
        if (date != null) {
            this.trigger.setStartTime(date);
        }
    }

    public void setEndTime(String endTime) {
        Date date = this.parse(endTime);
        if (date != null) {
            this.trigger.setEndTime(date);
        }
    }

    private Date parse(String value) {
        String[] formats;
        for (String format : formats = new String[]{"EEE MMM d HH:mm:ss z yyyy", "EEE, d MMM yyyy HH:mm:ss Z", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss.SZ", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm", "yyyy-MM-dd'T'HH:mm:ss.SZ", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyyMMdd"}) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            try {
                return dateFormat.parse(value);
            }
            catch (ParseException e) {
                this.invalidProperty = new InvalidPropertyException("Invalid time format " + value, e);
            }
        }
        return null;
    }

    @Override
    public void validate() throws InvalidPropertyException {
        if (this.invalidProperty != null) {
            throw this.invalidProperty;
        }
        try {
            this.detail.validate();
            this.trigger.validate();
        }
        catch (SchedulerException e) {
            throw new InvalidPropertyException(e);
        }
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    MessageEndpoint getEndpoint() {
        return this.endpoint;
    }

    void setEndpoint(MessageEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    CronTrigger getTrigger() {
        return this.trigger;
    }

    JobDetail getDetail() {
        return this.detail;
    }
}

