/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ActiveMQ5Factory
implements BrokerFactoryHandler {
    private static final ThreadLocal<Properties> threadProperties = new ThreadLocal();
    private static final Map<URI, BrokerService> brokers = new HashMap<URI, BrokerService>();
    private static Throwable throwable = null;

    public static void setThreadProperties(Properties value) {
        threadProperties.set(value);
    }

    public synchronized BrokerService createBroker(URI brokerURI) throws Exception {
        BrokerService broker = brokers.get(brokerURI);
        if (null == broker || !broker.isStarted()) {
            URI uri = new URI(brokerURI.getRawSchemeSpecificPart());
            broker = BrokerFactory.createBroker((URI)uri);
            brokers.put(brokerURI, broker);
            if (!uri.getScheme().toLowerCase().startsWith("xbean")) {
                Properties properties = this.getLowerCaseProperties();
                Object value = properties.get("datasource");
                if (value instanceof String && value.toString().length() == 0) {
                    value = null;
                }
                if (value != null) {
                    DataSource dataSource;
                    if (value instanceof DataSource) {
                        dataSource = (DataSource)value;
                    } else {
                        String resouceId = (String)value;
                        try {
                            ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
                            Context context = containerSystem.getJNDIContext();
                            Object obj = context.lookup("openejb/Resource/" + resouceId);
                            if (!(obj instanceof DataSource)) {
                                throw new IllegalArgumentException("Resource with id " + resouceId + " is not a DataSource, but is " + obj.getClass().getName());
                            }
                            dataSource = (DataSource)obj;
                        }
                        catch (NamingException e) {
                            throw new IllegalArgumentException("Unknown datasource " + resouceId);
                        }
                    }
                    JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
                    if (properties.containsKey("usedatabaselock")) {
                        persistenceAdapter.setUseDatabaseLock(Boolean.parseBoolean(properties.getProperty("usedatabaselock", "true")));
                    }
                    persistenceAdapter.setDataSource(dataSource);
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                } else {
                    MemoryPersistenceAdapter persistenceAdapter = new MemoryPersistenceAdapter();
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                }
                try {
                    broker.setSchedulerSupport(false);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                broker.setUseLoggingForShutdownErrors(Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").isErrorEnabled());
            }
            broker.setUseShutdownHook(false);
            broker.setSystemExitOnShutdown(false);
            if (!broker.isStarted()) {
                final BrokerService bs = broker;
                Thread start = new Thread("ActiveMQFactory start and checkpoint"){

                    @Override
                    public void run() {
                        try {
                            bs.start();
                            bs.waitUntilStarted();
                            bs.getPersistenceAdapter().checkpoint(true);
                        }
                        catch (Throwable t) {
                            throwable = t;
                        }
                    }
                };
                start.setDaemon(true);
                start.start();
                try {
                    start.join(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (null != throwable) {
                    Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").error("ActiveMQ failed to start within 5 seconds - It may not be usable", throwable);
                }
            }
        }
        return broker;
    }

    private Properties getLowerCaseProperties() {
        Properties properties = threadProperties.get();
        Properties newProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = ((String)key).toLowerCase();
                }
                newProperties.put(key, entry.getValue());
            }
        }
        return newProperties;
    }

    public Collection<BrokerService> getBrokers() {
        return brokers.values();
    }
}

