/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.apache.openejb.loader.SystemInstance;

public class BasicPolicyConfiguration
implements PolicyConfiguration {
    static final int OPEN = 1;
    static final int IN_SERVICE = 2;
    static final int DELETED = 3;
    private final String contextID;
    private int state;
    protected final Map<String, Permissions> rolePermissionsMap = new LinkedHashMap<String, Permissions>();
    protected Permissions unchecked = null;
    protected Permissions excluded = null;

    protected BasicPolicyConfiguration(String contextID) {
        this.contextID = contextID;
        this.state = 1;
    }

    @Override
    public String getContextID() throws PolicyContextException {
        return this.contextID;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (this.excluded != null && this.excluded.implies(permission)) {
            return false;
        }
        if (this.unchecked != null && this.unchecked.implies(permission)) {
            return true;
        }
        Principal[] principals = domain.getPrincipals();
        if (principals.length == 0) {
            return false;
        }
        RoleResolver roleResolver = SystemInstance.get().getComponent(RoleResolver.class);
        Set<String> roles = roleResolver.getLogicalRoles(principals, this.rolePermissionsMap.keySet());
        for (String role : roles) {
            Permissions permissions = this.rolePermissionsMap.get(role);
            if (permissions == null || !permissions.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.addToRole(roleName, e.nextElement());
        }
    }

    @Override
    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Permissions permissions = this.rolePermissionsMap.get(roleName);
        if (permissions == null) {
            permissions = new Permissions();
            this.rolePermissionsMap.put(roleName, permissions);
        }
        permissions.add(permission);
    }

    @Override
    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.addToUncheckedPolicy(e.nextElement());
        }
    }

    @Override
    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        if (this.unchecked == null) {
            this.unchecked = new Permissions();
        }
        this.unchecked.add(permission);
    }

    @Override
    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.addToExcludedPolicy(e.nextElement());
        }
    }

    @Override
    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        if (this.excluded == null) {
            this.excluded = new Permissions();
        }
        this.excluded.add(permission);
    }

    @Override
    public void removeRole(String roleName) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.rolePermissionsMap.remove(roleName);
    }

    @Override
    public void removeUncheckedPolicy() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.unchecked = null;
    }

    @Override
    public void removeExcludedPolicy() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.excluded = null;
    }

    @Override
    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
    }

    @Override
    public void delete() throws PolicyContextException {
        this.state = 3;
    }

    @Override
    public void commit() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.state = 2;
    }

    @Override
    public boolean inService() throws PolicyContextException {
        return this.state == 2;
    }

    public void open(boolean remove) {
        if (remove) {
            this.rolePermissionsMap.clear();
            this.unchecked = null;
            this.excluded = null;
        }
        this.state = 1;
    }

    int getState() {
        return this.state;
    }

    public static interface RoleResolver {
        public Set<String> getLogicalRoles(Principal[] var1, Set<String> var2);
    }
}

