/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.ResourceLink;

class DebuggableVmHackery
implements DynamicDeployer {
    DebuggableVmHackery() {
    }

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            Map<String, EjbDeployment> deployments = openejbJar.getDeploymentsByEjbName();
            ejbJar.setRelationships(null);
            ArrayList<String> removed = new ArrayList<String>();
            for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
                String ejbName = enterpriseBean.getEjbName();
                EjbDeployment ejbDeployment = deployments.get(ejbName);
                this.pruneRefs(enterpriseBean, ejbDeployment);
                if (!(enterpriseBean instanceof MessageDrivenBean) && !(enterpriseBean instanceof EntityBean)) continue;
                ejbJar.removeEnterpriseBean(ejbName);
                openejbJar.removeEjbDeployment(ejbDeployment);
                removed.add(ejbName);
                AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
                if (assemblyDescriptor == null) continue;
                for (MethodPermission permission : this.copy(assemblyDescriptor.getMethodPermission())) {
                    for (Method method : this.copy(permission.getMethod())) {
                        if (!method.getEjbName().equals(ejbName)) continue;
                        permission.getMethod().remove(method);
                    }
                    if (permission.getMethod().size() != 0) continue;
                    assemblyDescriptor.getMethodPermission().remove(permission);
                }
                for (ContainerTransaction transaction : this.copy(assemblyDescriptor.getContainerTransaction())) {
                    for (Method method : this.copy(transaction.getMethod())) {
                        if (!method.getEjbName().equals(ejbName)) continue;
                        transaction.getMethod().remove(method);
                    }
                    if (transaction.getMethod().size() != 0) continue;
                    assemblyDescriptor.getContainerTransaction().remove(transaction);
                }
                for (InterceptorBinding binding : this.copy(assemblyDescriptor.getInterceptorBinding())) {
                    if (!binding.getEjbName().equals(ejbName)) continue;
                    assemblyDescriptor.getInterceptorBinding().remove(binding);
                }
            }
            for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
                enterpriseBean.getEjbLocalRefMap().keySet().removeAll(removed);
                enterpriseBean.getEjbRefMap().keySet().removeAll(removed);
            }
            for (JndiConsumer jndiConsumer : ejbJar.getInterceptors()) {
                this.pruneRefs(jndiConsumer, new EjbDeployment());
            }
        }
        return appModule;
    }

    private void pruneRefs(JndiConsumer bean, EjbDeployment ejbDeployment) {
        ResourceLink resourceLink;
        for (ResourceRef resourceRef : this.copy(bean.getResourceRef())) {
            if (!resourceRef.getResType().startsWith("javax.jms.")) continue;
            resourceLink = ejbDeployment.getResourceLink(resourceRef.getName());
            ejbDeployment.getResourceLink().remove(resourceLink);
            bean.getResourceRef().remove(resourceRef);
        }
        for (ResourceEnvRef resourceEnvRef : bean.getResourceEnvRef()) {
            resourceLink = ejbDeployment.getResourceLink(resourceEnvRef.getName());
            ejbDeployment.getResourceLink().remove(resourceLink);
        }
        bean.getResourceEnvRef().clear();
        for (MessageDestinationRef messageDestinationRef : bean.getMessageDestinationRef()) {
            resourceLink = ejbDeployment.getResourceLink(messageDestinationRef.getName());
            ejbDeployment.getResourceLink().remove(resourceLink);
        }
        bean.getMessageDestinationRef().clear();
        bean.getPersistenceContextRef().clear();
        bean.getPersistenceUnitRef().clear();
    }

    public <T> List<T> copy(Collection<T> list) {
        return new ArrayList<T>(list);
    }
}

