/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;

public class CdiInterceptor
implements Serializable {
    private final CdiEjbBean<Object> bean;
    private final BeanManagerImpl manager;
    private final CdiAppContextsService contextService;
    private final WebBeansContext webBeansContext;

    public CdiInterceptor(CdiEjbBean<Object> bean, BeanManagerImpl manager, CdiAppContextsService contextService) {
        this.bean = bean;
        this.manager = manager;
        this.contextService = contextService;
        this.webBeansContext = bean.getWebBeansContext();
    }

    @AroundTimeout
    @AroundInvoke
    public Object aroundInvoke(final InvocationContext ejbContext) throws Exception {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return CdiInterceptor.this.invoke(ejbContext);
            }
        };
        return callable.call();
    }

    private Object invoke(InvocationContext ejbContext) throws Exception {
        CreationalContext<?> context = this.getCreationalContext();
        Object instance = ejbContext.getTarget();
        if (this.bean.getDecoratorStack().size() > 0) {
            Class<?> proxyClass = this.webBeansContext.getJavassistProxyFactory().getInterceptorProxyClasses().get(this.bean);
            if (proxyClass == null) {
                ProxyFactory delegateFactory = this.webBeansContext.getJavassistProxyFactory().createProxyFactory(this.bean);
                proxyClass = this.webBeansContext.getJavassistProxyFactory().getProxyClass(delegateFactory);
                this.webBeansContext.getJavassistProxyFactory().getInterceptorProxyClasses().put(this.bean, proxyClass);
            }
            Object delegate = proxyClass.newInstance();
            DelegateHandler delegateHandler = new DelegateHandler(this.bean, ejbContext);
            ((ProxyObject)delegate).setHandler(delegateHandler);
            List<Object> decorators = WebBeansDecoratorConfig.getDecoratorStack(this.bean, instance, delegate, (CreationalContextImpl)context);
            delegateHandler.setDecorators(decorators);
            return delegateHandler.invoke(instance, ejbContext.getMethod(), null, ejbContext.getParameters());
        }
        return ejbContext.proceed();
    }

    private CreationalContext<?> getCreationalContext() {
        return this.manager.createCreationalContext(null);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new IntraVmArtifact(this, true);
    }

    public class ScopeActivator
    implements Callable {
        private final Callable callable;
        private final Class<? extends Annotation> scopeType;

        public ScopeActivator(Callable callable, Class<? extends Annotation> scopeType) {
            this.callable = callable;
            this.scopeType = scopeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            Context ctx = CdiInterceptor.this.contextService.getCurrentContext(this.scopeType);
            if (ctx == null) {
                CdiInterceptor.this.contextService.startContext(this.scopeType, null);
            } else if (!ctx.isActive()) {
                CdiInterceptor.this.contextService.activateContext(this.scopeType);
            }
            try {
                Object v = this.callable.call();
                return v;
            }
            finally {
                if (ctx == null) {
                    CdiInterceptor.this.contextService.endContext(this.scopeType, null);
                }
            }
        }
    }
}

