/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.apache.openejb.assembler.classic.ValidatorFactoryWrapper;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;

public class EntityManagerFactoryCallable
implements Callable<EntityManagerFactory> {
    private final String persistenceProviderClassName;
    private final PersistenceUnitInfoImpl unitInfo;

    public EntityManagerFactoryCallable(String persistenceProviderClassName, PersistenceUnitInfoImpl unitInfo) {
        this.persistenceProviderClassName = persistenceProviderClassName;
        this.unitInfo = unitInfo;
    }

    @Override
    public EntityManagerFactory call() throws Exception {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.persistenceProviderClassName);
        PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
        HashMap<String, ValidatorFactoryWrapper> properties = new HashMap<String, ValidatorFactoryWrapper>();
        properties.put("javax.persistence.validator.ValidatorFactory", new ValidatorFactoryWrapper());
        EntityManagerFactory emf = persistenceProvider.createContainerEntityManagerFactory(this.unitInfo, properties);
        return emf;
    }

    public PersistenceUnitInfoImpl getUnitInfo() {
        return this.unitInfo;
    }
}

