/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.LocalXAResource;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class LocalXAResourceInsertionInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final String name;

    public LocalXAResourceInsertionInterceptor(ConnectionInterceptor next, String name) {
        this.next = next;
        this.name = name;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        mci.setXAResource(new LocalXAResource(mci.getManagedConnection().getLocalTransaction(), this.name));
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    public void destroy() {
        this.next.destroy();
    }

    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[name=").append(this.name).append("]\n");
        if (this.next == null) {
            s.append("<end>");
        } else {
            this.next.info(s);
        }
    }
}

