/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoConnectionEventListener
implements ConnectionEventListener {
    private static Logger log = LoggerFactory.getLogger(GeronimoConnectionEventListener.class.getName());
    private final ManagedConnectionInfo managedConnectionInfo;
    private final ConnectionInterceptor stack;
    private final List<ConnectionInfo> connectionInfos = new ArrayList<ConnectionInfo>();
    private boolean errorOccurred = false;

    public GeronimoConnectionEventListener(ConnectionInterceptor stack, ManagedConnectionInfo managedConnectionInfo) {
        this.stack = stack;
        this.managedConnectionInfo = managedConnectionInfo;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        block5: {
            if (connectionEvent.getSource() != this.managedConnectionInfo.getManagedConnection()) {
                throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection. Expected " + this.managedConnectionInfo.getManagedConnection() + ", actual " + connectionEvent.getSource());
            }
            if (log.isTraceEnabled()) {
                log.trace("connectionClosed called with " + connectionEvent.getConnectionHandle() + " for MCI: " + this.managedConnectionInfo + " and MC: " + this.managedConnectionInfo.getManagedConnection());
            }
            ConnectionInfo ci = new ConnectionInfo(this.managedConnectionInfo);
            ci.setConnectionHandle(connectionEvent.getConnectionHandle());
            try {
                this.stack.returnConnection(ci, ConnectionReturnAction.RETURN_HANDLE);
            }
            catch (Throwable e) {
                if (log.isTraceEnabled()) {
                    log.trace("connectionClosed failed with " + connectionEvent.getConnectionHandle() + " for MCI: " + this.managedConnectionInfo + " and MC: " + this.managedConnectionInfo.getManagedConnection(), e);
                }
                if (!(e instanceof Error)) break block5;
                throw (Error)e;
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (connectionEvent.getSource() != this.managedConnectionInfo.getManagedConnection()) {
            throw new IllegalArgumentException("ConnectionError event received from wrong ManagedConnection. Expected " + this.managedConnectionInfo.getManagedConnection() + ", actual " + connectionEvent.getSource());
        }
        log.warn("connectionErrorOccurred called with " + connectionEvent.getConnectionHandle(), connectionEvent.getException());
        boolean errorOccurred = this.errorOccurred;
        this.errorOccurred = true;
        if (!errorOccurred) {
            ConnectionInfo ci = new ConnectionInfo(this.managedConnectionInfo);
            ci.setConnectionHandle(connectionEvent.getConnectionHandle());
            this.stack.returnConnection(ci, ConnectionReturnAction.DESTROY);
        }
    }

    @Override
    public void localTransactionStarted(ConnectionEvent event) {
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent event) {
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void addConnectionInfo(ConnectionInfo connectionInfo) {
        assert (connectionInfo.getConnectionHandle() != null);
        this.connectionInfos.add(connectionInfo);
    }

    public void removeConnectionInfo(ConnectionInfo connectionInfo) {
        assert (connectionInfo.getConnectionHandle() != null);
        this.connectionInfos.remove(connectionInfo);
    }

    public boolean hasConnectionInfos() {
        return !this.connectionInfos.isEmpty();
    }

    public void clearConnectionInfos() {
        this.connectionInfos.clear();
    }

    public boolean hasConnectionInfo(ConnectionInfo connectionInfo) {
        return this.connectionInfos.contains(connectionInfo);
    }

    public boolean isFirstConnectionInfo(ConnectionInfo connectionInfo) {
        return !this.connectionInfos.isEmpty() && this.connectionInfos.get(0) == connectionInfo;
    }

    public Collection<ConnectionInfo> getConnectionInfos() {
        return Collections.unmodifiableCollection(this.connectionInfos);
    }
}

