/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.geronimo.connector.ConnectionReleaser;
import org.apache.geronimo.connector.outbound.TransactionCachingInterceptor;
import org.apache.geronimo.transaction.manager.TransactionImpl;

public class ConnectorTransactionContext {
    private static final ConcurrentHashMap<Transaction, ConnectorTransactionContext> DATA_INDEX = new ConcurrentHashMap();
    private Map<ConnectionReleaser, TransactionCachingInterceptor.ManagedConnectionInfos> managedConnections;

    public static ConnectorTransactionContext get(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("transaction is null");
        }
        ConnectorTransactionContext ctx = DATA_INDEX.get(transaction);
        if (ctx == null) {
            ctx = new ConnectorTransactionContext();
            try {
                int status = transaction.getStatus();
                if (status != 3 && status != 4 && status != 5) {
                    ((TransactionImpl)transaction).registerInterposedSynchronization(new ConnectorSynchronization(ctx, transaction));
                    DATA_INDEX.putIfAbsent(transaction, ctx);
                }
            }
            catch (SystemException e) {
                throw new RuntimeException("Unable to register ejb transaction synchronization callback", e);
            }
        }
        return ctx;
    }

    public static TransactionCachingInterceptor.ManagedConnectionInfos get(Transaction transaction, ConnectionReleaser key) {
        ConnectorTransactionContext ctx = ConnectorTransactionContext.get(transaction);
        TransactionCachingInterceptor.ManagedConnectionInfos infos = ctx.getManagedConnectionInfo(key);
        if (infos == null) {
            infos = new TransactionCachingInterceptor.ManagedConnectionInfos();
            ctx.setManagedConnectionInfo(key, infos);
        }
        return infos;
    }

    private static void remove(Transaction transaction) {
        DATA_INDEX.remove(transaction);
    }

    private synchronized TransactionCachingInterceptor.ManagedConnectionInfos getManagedConnectionInfo(ConnectionReleaser key) {
        if (this.managedConnections == null) {
            return null;
        }
        return this.managedConnections.get(key);
    }

    private synchronized void setManagedConnectionInfo(ConnectionReleaser key, TransactionCachingInterceptor.ManagedConnectionInfos info) {
        if (this.managedConnections == null) {
            this.managedConnections = new HashMap<ConnectionReleaser, TransactionCachingInterceptor.ManagedConnectionInfos>();
        }
        this.managedConnections.put(key, info);
    }

    private static class ConnectorSynchronization
    implements Synchronization {
        private final ConnectorTransactionContext ctx;
        private final Transaction transaction;

        public ConnectorSynchronization(ConnectorTransactionContext ctx, Transaction transaction) {
            this.ctx = ctx;
            this.transaction = transaction;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                ConnectorTransactionContext connectorTransactionContext = this.ctx;
                synchronized (connectorTransactionContext) {
                    if (this.ctx.managedConnections != null) {
                        for (Map.Entry entry : this.ctx.managedConnections.entrySet()) {
                            ConnectionReleaser key = (ConnectionReleaser)entry.getKey();
                            key.afterCompletion(entry.getValue());
                        }
                        this.ctx.managedConnections.clear();
                    }
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ConnectorTransactionContext.remove(this.transaction);
                throw throwable;
            }
            ConnectorTransactionContext.remove(this.transaction);
        }
    }
}

