/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.realm;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.ietf.jgss.GSSContext;

public class LowTypedRealm
implements Realm {
    private static final Class<?>[] SIMPLE_AUTHENTICATE_ARGS = new Class[]{String.class, String.class};
    private static final Class<?>[] AUTHENTICATE_ARGS = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static final Class<?>[] GSCONTEXT_AUTHENTICATE = new Class[]{GSSContext.class, Boolean.class};
    private static final Class<?>[] X509CERT_AUTHENTICATE = new Class[]{X509Certificate[].class};
    private static final Class<?>[] FIND_SECURITY_CONSTRAINTS_CONSTRAINT = new Class[]{HttpServletRequest.class, String.class};
    private static final Class<?>[] HAS_RESOURCE_PERMISSION_CONSTRAINT = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Object[].class, String.class};
    private static final Class<?>[] HAS_ROLE_CONSTRAINT = new Class[]{Principal.class, String.class};
    private static final Class<?>[] HAS_USER_DATA_PERMISSION_CONSTRAINT = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Object[].class};
    private final Object delegate;
    private final String info;
    private final Method simpleAuthenticateMethod;
    private final Method authenticateMethod;
    private final Method gsMethod;
    private final Method findSecurityConstraintsMethod;
    private final Method x509Method;
    private final Method hasResourcePermissionMethod;
    private final Method hasRoleConstraintMethod;
    private final Method hasUserDataMethod;
    private Container container;

    public LowTypedRealm(Object delegate) {
        this.delegate = delegate;
        this.info = delegate.getClass() + "/1.0";
        Class<?> clazz = delegate.getClass();
        this.simpleAuthenticateMethod = this.findMethod(clazz, SIMPLE_AUTHENTICATE_ARGS);
        this.authenticateMethod = this.findMethod(clazz, AUTHENTICATE_ARGS);
        this.gsMethod = this.findMethod(clazz, GSCONTEXT_AUTHENTICATE);
        this.findSecurityConstraintsMethod = this.findMethod(clazz, FIND_SECURITY_CONSTRAINTS_CONSTRAINT);
        this.x509Method = this.findMethod(clazz, X509CERT_AUTHENTICATE);
        this.hasResourcePermissionMethod = this.findMethod(clazz, HAS_RESOURCE_PERMISSION_CONSTRAINT);
        this.hasRoleConstraintMethod = this.findMethod(clazz, HAS_ROLE_CONSTRAINT);
        this.hasUserDataMethod = this.findMethod(clazz, HAS_USER_DATA_PERMISSION_CONSTRAINT);
    }

    private Method findMethod(Class<?> clazz, Class<?>[] argTypes) {
        for (Method mtd : clazz.getMethods()) {
            if (Modifier.isAbstract(mtd.getModifiers())) continue;
            boolean match = true;
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?>[] params = mtd.getParameterTypes();
                if (params.length != argTypes.length) {
                    match = false;
                    break;
                }
                if (argTypes[i].isAssignableFrom(params[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return mtd;
        }
        return null;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public String getInfo() {
        return this.info;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Principal authenticate(String username, String credentials) {
        return (Principal)this.invoke(this.simpleAuthenticateMethod, username, credentials);
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return (Principal)this.invoke(this.authenticateMethod, username, digest, nonce, nc, cnonce, qop, realm, md5a2);
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        return (Principal)this.invoke(this.gsMethod, gssContext, storeCreds);
    }

    public Principal authenticate(X509Certificate[] certs) {
        return (Principal)this.invoke(this.x509Method, certs);
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        return (Boolean)this.invoke(this.hasRoleConstraintMethod, principal, role);
    }

    public void backgroundProcess() {
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        Map map = (Map)this.invoke(this.findSecurityConstraintsMethod, request.getRequest(), context.getPath());
        ArrayList<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
        for (Map.Entry entry : map.entrySet()) {
            constraints.addAll(Arrays.asList(SecurityConstraint.createConstraints((ServletSecurityElement)((ServletSecurityElement)entry.getValue()), (String)((String)entry.getKey()))));
        }
        return constraints.toArray(new SecurityConstraint[constraints.size()]);
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraint, Context context) throws IOException {
        return (Boolean)this.invoke(this.hasResourcePermissionMethod, request.getRequest(), response.getResponse(), constraint, context.getPath());
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraint) throws IOException {
        return (Boolean)this.invoke(this.hasUserDataMethod, request.getRequest(), response.getResponse(), constraint);
    }

    private Object invoke(Method method, Object ... args) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new TomEERuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new TomEERuntimeException(e);
        }
    }
}

