/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.geronimo.osgi.locator.ProviderLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FactoryFinder {
    private static final boolean debug = false;

    FactoryFinder() {
    }

    private static void debugPrintln(String msg) {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        Method m = null;
        try {
            m = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            FactoryFinder.debugPrintln("assuming JDK 1.1");
            return FactoryFinder.class.getClassLoader();
        }
        try {
            return (ClassLoader)m.invoke((Object)Thread.currentThread(), null);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationError("Unexpected IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationError("Unexpected InvocationTargetException", e);
        }
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            return ProviderLocator.loadClass((String)className, FactoryFinder.class, (ClassLoader)classLoader).newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(Class<?> factoryType, String fallbackClassName) throws ConfigurationError {
        String factoryId = factoryType.getName();
        FactoryFinder.debugPrintln("debug is on");
        ClassLoader classLoader = FactoryFinder.findClassLoader();
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                FactoryFinder.debugPrintln("found system property " + systemProp);
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            String factoryClassName = ProviderLocator.lookupByJREPropertyFile((String)("lib" + File.separator + "jaxrpc.properties"), (String)factoryId);
            if (factoryClassName != null) {
                FactoryFinder.debugPrintln("found java.home property " + factoryClassName);
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Object service = ProviderLocator.getService((String)factoryId, FactoryFinder.class, (ClassLoader)classLoader);
            if (service != null) {
                return service;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

