/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;

public class UrlCache {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, UrlCache.class);
    public static final boolean antiJarLocking = SystemInstance.get().getOptions().get("antiJarLocking", false);
    public static final File cacheDir;
    private final Map<String, Map<URL, File>> cache = new TreeMap<String, Map<URL, File>>();

    public synchronized URL[] cacheUrls(String appId, URL[] urls) {
        if (!antiJarLocking) {
            return urls;
        }
        LinkedHashSet<URL> cachedUrls = new LinkedHashSet<URL>();
        LinkedList<URL> locationStack = new LinkedList<URL>(Arrays.asList(urls));
        while (!locationStack.isEmpty()) {
            URL url = locationStack.removeFirst();
            if (cachedUrls.contains(url)) continue;
            File file = this.cacheUrl(appId, url);
            if (file != null) {
                try {
                    cachedUrls.add(file.toURI().toURL());
                    List<URL> manifestClassPath = this.getManifestClassPath(url, file);
                    locationStack.addAll(0, manifestClassPath);
                }
                catch (MalformedURLException e) {
                    logger.error("Error caching url. Original jar file will be used which may result in a file lock: url=" + url, e);
                    cachedUrls.add(url);
                }
                continue;
            }
            cachedUrls.add(url);
        }
        return cachedUrls.toArray(new URL[cachedUrls.size()]);
    }

    public synchronized void releaseUrls(String appId) {
        logger.debug("Releasing URLs for application " + appId);
        Map<URL, File> urlFileMap = this.cache.remove(appId);
        if (urlFileMap != null) {
            for (File file : urlFileMap.values()) {
                if (file.delete()) {
                    logger.debug("Deleted cached file " + file);
                    continue;
                }
                logger.debug("Unable to delete cached file " + file);
            }
        }
    }

    public File getUrlCachedName(String appId, URL url) {
        Map<URL, File> appCache = this.getAppCache(appId);
        if (appCache.containsKey(url)) {
            return appCache.get(url);
        }
        return null;
    }

    public boolean isUrlCached(String appId, URL url) {
        Map<URL, File> appCache = this.getAppCache(appId);
        return appCache.containsKey(url);
    }

    public URL getUrlKeyCached(String appId, File file) {
        URL keyUrl;
        if (file == null) {
            return null;
        }
        Map<URL, File> appCache = this.getAppCache(appId);
        for (Map.Entry<URL, File> entry : appCache.entrySet()) {
            if (!entry.getValue().equals(file)) continue;
            return entry.getKey();
        }
        try {
            keyUrl = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (appCache.containsKey(keyUrl)) {
            return keyUrl;
        }
        return null;
    }

    private synchronized File cacheUrl(String appId, URL url) {
        boolean success;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        File sourceFile = URLs.toFile(url);
        if (!sourceFile.exists()) {
            return null;
        }
        if (!sourceFile.canRead()) {
            return null;
        }
        if (sourceFile.isDirectory()) {
            return sourceFile;
        }
        sourceFile = sourceFile.getAbsoluteFile();
        try {
            url = sourceFile.toURI().toURL();
        }
        catch (MalformedURLException ignored) {
            // empty catch block
        }
        Map<URL, File> appCache = this.getAppCache(appId);
        if (appCache.containsKey(url)) {
            return appCache.get(url);
        }
        if (sourceFile.getParentFile().equals(cacheDir)) {
            appCache.put(url, sourceFile);
            return sourceFile;
        }
        String name = sourceFile.getName();
        int dot = name.lastIndexOf(".");
        String prefix = name;
        String suffix = "";
        if (dot > 0) {
            prefix = name.substring(0, dot) + "-";
            suffix = name.substring(dot, name.length());
        }
        File cacheFile = null;
        try {
            try {
                cacheFile = File.createTempFile(prefix, suffix, cacheDir);
            }
            catch (Throwable e) {
                File tmp = new File("tmp");
                if (!tmp.exists() && !tmp.mkdirs()) {
                    throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
                }
                cacheFile = File.createTempFile(prefix, suffix, tmp);
            }
            cacheFile.deleteOnExit();
            success = JarExtractor.copyRecursively(sourceFile, cacheFile);
        }
        catch (IOException e) {
            success = false;
        }
        if (success) {
            appCache.put(url, cacheFile);
            logger.debug("Coppied jar file to " + cacheFile);
            return cacheFile;
        }
        JarExtractor.delete(cacheFile);
        logger.error("Unable to copy jar into URL cache directory. Original jar file will be used which may result in a file lock: file=" + sourceFile);
        return null;
    }

    private synchronized Map<URL, File> getAppCache(String appId) {
        Map<URL, File> urlFileMap = this.cache.get(appId);
        if (urlFileMap == null) {
            urlFileMap = new LinkedHashMap<URL, File>();
            this.cache.put(appId, urlFileMap);
        }
        return urlFileMap;
    }

    private List<URL> getManifestClassPath(URL codeSource, File location) {
        try {
            Manifest manifest = this.loadManifest(location);
            if (manifest == null) {
                return Collections.emptyList();
            }
            String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (manifestClassPath == null) {
                return Collections.emptyList();
            }
            LinkedList<URL> classPathUrls = new LinkedList<URL>();
            StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                try {
                    URL entryUrl = new URL(codeSource, entry);
                    classPathUrls.addLast(entryUrl);
                }
                catch (MalformedURLException ignored) {}
            }
            return classPathUrls;
        }
        catch (IOException ignored) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifest(File location) throws IOException {
        if (location.isDirectory()) {
            File manifestFile = new File(location, "META-INF/MANIFEST.MF");
            if (manifestFile.isFile() && manifestFile.canRead()) {
                InputStream in = null;
                try {
                    in = IO.read(manifestFile);
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
                finally {
                    UrlCache.close(in);
                }
            }
        } else {
            JarFile jarFile = new JarFile(location);
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            finally {
                UrlCache.close(jarFile);
            }
        }
        return null;
    }

    private static File createCacheDir() {
        try {
            FileUtils openejbBase = SystemInstance.get().getBase();
            File dir = null;
            if (SystemInstance.get().getConf(null).exists()) {
                try {
                    dir = openejbBase.getDirectory("temp");
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (dir == null) {
                dir = Files.tmpdir();
            }
            if (dir.exists()) {
                File[] files = dir.listFiles();
                if (null != files) {
                    for (File f : files) {
                        UrlCache.deleteDir(f);
                    }
                }
            } else {
                dir = UrlCache.createCacheDir(new File(dir.getAbsolutePath()));
            }
            return dir;
        }
        catch (IOException e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    private static File createCacheDir(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("Cache temp directory held by file: " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("Unable to create cache temp directory: " + dir);
        }
        Thread.yield();
        return dir;
    }

    public static void deleteDir(File dir) {
        if (dir == null) {
            return;
        }
        File[] fileNames = dir.listFiles();
        if (fileNames != null) {
            for (File file : fileNames) {
                if (file.isDirectory()) {
                    UrlCache.deleteDir(file);
                    continue;
                }
                if (file.delete()) {
                    logger.debug("Deleted file " + file);
                    continue;
                }
                logger.debug("Unable to delete file " + file);
            }
        }
        if (dir.delete()) {
            logger.debug("Deleted file " + dir);
        } else {
            logger.debug("Unable to delete file " + dir);
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void close(JarFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        if (antiJarLocking) {
            cacheDir = UrlCache.createCacheDir();
            logger.info("AntiJarLocking enabled. Using URL cache dir " + cacheDir);
        } else {
            cacheDir = null;
        }
    }
}

