/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import org.apache.activemq.broker.BrokerService;
import org.apache.openejb.resource.activemq.ActiveMQFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URISupport;
import org.apache.openejb.util.URLs;

public class ActiveMQResourceAdapter
extends org.apache.activemq.ra.ActiveMQResourceAdapter {
    private String dataSource;
    private String useDatabaseLock;
    private String startupTimeout = "60000";
    private BootstrapContext bootstrapContext;

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseDatabaseLock(String useDatabaseLock) {
        this.useDatabaseLock = useDatabaseLock;
    }

    public int getStartupTimeout() {
        return Integer.parseInt(this.startupTimeout);
    }

    public void setStartupTimeout(Duration startupTimeout) {
        if (startupTimeout.getUnit() == null) {
            startupTimeout.setUnit(TimeUnit.MILLISECONDS);
        }
        this.startupTimeout = String.valueOf(TimeUnit.MILLISECONDS.convert(startupTimeout.getTime(), startupTimeout.getUnit()));
    }

    public void setServerUrl(String url) {
        super.setServerUrl(url);
    }

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        String brokerXmlConfig = this.getBrokerXmlConfig();
        super.setBrokerXmlConfig(null);
        super.start(bootstrapContext);
        Properties properties = new Properties();
        if (null != this.dataSource) {
            properties.put("DataSource", this.dataSource);
        }
        if (null != this.useDatabaseLock) {
            properties.put("UseDatabaseLock", this.useDatabaseLock);
        }
        if (null != this.startupTimeout) {
            properties.put("StartupTimeout", this.startupTimeout);
        }
        if (brokerXmlConfig != null && !brokerXmlConfig.trim().isEmpty()) {
            try {
                if (brokerXmlConfig.startsWith("broker:")) {
                    URISupport.CompositeData compositeData = URISupport.parseComposite(URLs.uri(brokerXmlConfig));
                    if (!compositeData.getParameters().containsKey("persistent")) {
                        compositeData.getParameters().put("persistent", "false");
                    }
                    if ("false".equalsIgnoreCase(compositeData.getParameters().get("persistent").toString())) {
                        properties.remove("DataSource");
                    }
                    this.setBrokerXmlConfig(ActiveMQFactory.getBrokerMetaFile() + compositeData.toURI());
                } else if (brokerXmlConfig.toLowerCase().startsWith("xbean:")) {
                    this.setBrokerXmlConfig(ActiveMQFactory.getBrokerMetaFile() + brokerXmlConfig);
                }
            }
            catch (URISyntaxException e) {
                throw new ResourceAdapterInternalException("Invalid BrokerXmlConfig", (Throwable)e);
            }
            this.createInternalBroker(brokerXmlConfig, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInternalBroker(String brokerXmlConfig, Properties properties) {
        ActiveMQFactory.setThreadProperties(properties);
        try {
            ActiveMQFactory.createBroker(URLs.uri(this.getBrokerXmlConfig())).start();
        }
        catch (Exception e) {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQResourceAdapter.class).getChildLogger("service").fatal("Failed to start ActiveMQ", e);
        }
        finally {
            ActiveMQFactory.setThreadProperties(null);
            if (brokerXmlConfig != null) {
                this.setBrokerXmlConfig(brokerXmlConfig);
            }
        }
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void stop() {
        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQResourceAdapter.class).getChildLogger("service").info("Stopping ActiveMQ");
        Thread stopThread = new Thread("ActiveMQResourceAdapter stop"){

            @Override
            public void run() {
                try {
                    ActiveMQResourceAdapter.this.stopImpl();
                }
                catch (Throwable t) {
                    Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQResourceAdapter.class).getChildLogger("service").error("ActiveMQ shutdown failed", t);
                }
            }
        };
        stopThread.setDaemon(true);
        stopThread.start();
        int timeout = 60000;
        try {
            timeout = Integer.parseInt(this.startupTimeout);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            stopThread.join(timeout);
        }
        catch (InterruptedException ex) {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQResourceAdapter.class).getChildLogger("service").warning("Gave up on ActiveMQ shutdown after " + timeout + "ms", ex);
        }
    }

    private void stopImpl() throws Exception {
        super.stop();
        Collection<BrokerService> brokers = ActiveMQFactory.getBrokers();
        Iterator<BrokerService> it = brokers.iterator();
        while (it.hasNext()) {
            BrokerService bs = it.next();
            try {
                bs.stop();
                bs.waitUntilStopped();
            }
            catch (Throwable t) {
                // empty catch block
            }
            it.remove();
        }
        ActiveMQResourceAdapter.stopScheduler();
        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQResourceAdapter.class).getChildLogger("service").info("Stopped ActiveMQ broker");
    }

    private static void stopScheduler() {
        try {
            Class<?> clazz = Class.forName("org.apache.kahadb.util.Scheduler");
            Method method = clazz.getMethod("shutdown", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

