/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.singleton;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.LockType;
import javax.interceptor.AroundInvoke;
import javax.xml.ws.handler.MessageContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.singleton.Instance;
import org.apache.openejb.core.singleton.SingletonInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.apache.openejb.core.webservices.NoAddressingSupport;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.xbean.finder.ClassFinder;

public class SingletonContainer
implements RpcContainer {
    private final SingletonInstanceManager instanceManager;
    private final HashMap<String, BeanContext> deploymentRegistry = new HashMap();
    private final ConcurrentMap<Class<?>, List<Method>> interceptorCache = new ConcurrentHashMap();
    private Object containerID;
    private final SecurityService securityService;
    private Duration accessTimeout;

    public SingletonContainer(Object id, SecurityService securityService) throws OpenEJBException {
        this.containerID = id;
        this.securityService = securityService;
        this.instanceManager = new SingletonInstanceManager(securityService);
        for (BeanContext beanContext : this.deploymentRegistry.values()) {
            beanContext.setContainer(this);
        }
    }

    public void setAccessTimeout(Duration duration) {
        this.accessTimeout = duration;
    }

    @Override
    public synchronized BeanContext[] getBeanContexts() {
        return this.deploymentRegistry.values().toArray(new BeanContext[this.deploymentRegistry.size()]);
    }

    @Override
    public synchronized BeanContext getBeanContext(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.SINGLETON;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        this.instanceManager.deploy(beanContext);
        String id = (String)beanContext.getDeploymentID();
        SingletonContainer singletonContainer = this;
        synchronized (singletonContainer) {
            this.deploymentRegistry.put(id, beanContext);
            beanContext.setContainer(this);
        }
    }

    @Override
    public void start(BeanContext info) throws OpenEJBException {
        this.instanceManager.start(info);
        EjbTimerService timerService = info.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    @Override
    public void stop(BeanContext info) throws OpenEJBException {
        info.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BeanContext beanContext) {
        ThreadContext threadContext = new ThreadContext(beanContext, null);
        ThreadContext old = ThreadContext.enter(threadContext);
        try {
            this.instanceManager.freeInstance(threadContext);
        }
        finally {
            ThreadContext.exit(old);
        }
        this.instanceManager.undeploy(beanContext);
        SingletonContainer singletonContainer = this;
        synchronized (singletonContainer) {
            String id = (String)beanContext.getDeploymentID();
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deploymentRegistry.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        BeanContext beanContext = this.getBeanContext(deployID);
        if (beanContext == null) {
            throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
        }
        if (type == null) {
            type = beanContext.getInterfaceType(callInterface);
        }
        Method runMethod = beanContext.getMatchingBeanMethod(callMethod);
        ThreadContext callContext = new ThreadContext(beanContext, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        CurrentCreationalContext currentCreationalContext = beanContext.get(CurrentCreationalContext.class);
        try {
            boolean authorized;
            boolean bl = authorized = type == InterfaceType.TIMEOUT || this.getSecurityService().isCallerAuthorized(callMethod, type);
            if (!authorized) {
                throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
            }
            Class<?> declaringClass = callMethod.getDeclaringClass();
            if (EJBHome.class.isAssignableFrom(declaringClass) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (callMethod.getName().startsWith("create")) {
                    ProxyInfo proxyInfo = this.createEJBObject(beanContext, callMethod);
                    return proxyInfo;
                }
                Object var14_15 = null;
                return var14_15;
            }
            if (EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) {
                Object var14_16 = null;
                return var14_16;
            }
            Instance instance = this.instanceManager.getInstance(callContext);
            callContext.setCurrentOperation(type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS);
            callContext.setCurrentAllowedStates(null);
            callContext.set(Method.class, runMethod);
            callContext.setInvokedInterface(callInterface);
            if (currentCreationalContext != null) {
                currentCreationalContext.set(instance.creationalContext);
            }
            Object object = this._invoke(callMethod, runMethod, args, instance, callContext, type);
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
            if (currentCreationalContext != null) {
                currentCreationalContext.remove();
            }
        }
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _invoke(Method callMethod, Method runMethod, Object[] args, Instance instance, ThreadContext callContext, InterfaceType callType) throws OpenEJBException {
        Object returnValue;
        block12: {
            BeanContext beanContext = callContext.getBeanContext();
            Duration accessTimeout = this.getAccessTimeout(beanContext, runMethod);
            boolean read = LockType.READ.equals((Object)beanContext.getConcurrencyAttribute(runMethod));
            Lock lock = this.aquireLock(read, accessTimeout, instance, runMethod);
            try {
                TransactionPolicy txPolicy;
                block11: {
                    txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, callType), callContext);
                    returnValue = null;
                    try {
                        if (callType == InterfaceType.SERVICE_ENDPOINT) {
                            callContext.setCurrentOperation(Operation.BUSINESS_WS);
                            returnValue = this.invokeWebService(args, beanContext, runMethod, instance);
                            break block11;
                        }
                        List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, callType == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS, interceptors, instance.interceptors);
                        returnValue = interceptorStack.invoke(args);
                    }
                    catch (Throwable e) {
                        try {
                            ExceptionType type = beanContext.getExceptionType(e);
                            if (type == ExceptionType.SYSTEM) {
                                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                            } else {
                                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                        }
                    }
                }
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            }
            finally {
                lock.unlock();
            }
        }
        return returnValue;
    }

    private Duration getAccessTimeout(BeanContext beanContext, Method callMethod) {
        Duration accessTimeout = beanContext.getAccessTimeout(callMethod);
        if (accessTimeout == null && (accessTimeout = beanContext.getAccessTimeout()) == null) {
            accessTimeout = this.accessTimeout;
        }
        return accessTimeout;
    }

    private Lock aquireLock(boolean read, Duration accessTimeout, Instance instance, Method runMethod) {
        boolean lockAcquired;
        Lock lock = read ? instance.lock.readLock() : instance.lock.writeLock();
        if (accessTimeout == null || accessTimeout.getTime() < 0L) {
            lock.lock();
            lockAcquired = true;
        } else if (accessTimeout.getTime() == 0L) {
            lockAcquired = lock.tryLock();
        } else {
            try {
                lockAcquired = lock.tryLock(accessTimeout.getTime(), accessTimeout.getUnit());
            }
            catch (InterruptedException e) {
                throw (ConcurrentAccessTimeoutException)new ConcurrentAccessTimeoutException("Unable to get " + (read ? "read" : "write") + " lock within specified time on '" + runMethod.getName() + "' method for: " + instance.bean.getClass().getName()).initCause((Throwable)e);
            }
        }
        if (!lockAcquired) {
            throw new ConcurrentAccessTimeoutException("Unable to get " + (read ? "read" : "write") + " lock on '" + runMethod.getName() + "' method for: " + instance.bean.getClass().getName());
        }
        return lock;
    }

    private Object invokeWebService(Object[] args, BeanContext beanContext, Method runMethod, Instance instance) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("WebService calls must follow format {messageContext, interceptor, [arg...]}.");
        }
        Object messageContext = args[0];
        if (messageContext == null) {
            throw new IllegalArgumentException("MessageContext is null.");
        }
        Object interceptor = args[1];
        if (interceptor == null) {
            throw new IllegalArgumentException("Interceptor instance is null.");
        }
        Class<?> interceptorClass = interceptor.getClass();
        HashMap<String, Object> interceptors = new HashMap<String, Object>(instance.interceptors);
        interceptors.put(interceptorClass.getName(), interceptor);
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>();
        InterceptorData providerData = new InterceptorData(interceptorClass);
        CopyOnWriteArrayList aroundInvokes = (CopyOnWriteArrayList)this.interceptorCache.get(interceptorClass);
        if (aroundInvokes == null) {
            CopyOnWriteArrayList value;
            aroundInvokes = new ClassFinder(new Class[]{interceptorClass}).findAnnotatedMethods(AroundInvoke.class);
            if (SingletonContainer.class.getClassLoader() == interceptorClass.getClassLoader() && (aroundInvokes = (List)this.interceptorCache.putIfAbsent(interceptorClass, value = new CopyOnWriteArrayList(aroundInvokes))) == null) {
                aroundInvokes = value;
            }
        }
        providerData.getAroundInvoke().addAll(aroundInvokes);
        interceptorDatas.add(0, providerData);
        interceptorDatas.addAll(beanContext.getMethodInterceptors(runMethod));
        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS_WS, interceptorDatas, interceptors);
        Object[] params = new Object[runMethod.getParameterTypes().length];
        if (messageContext instanceof javax.xml.rpc.handler.MessageContext) {
            ThreadContext.getThreadContext().set(javax.xml.rpc.handler.MessageContext.class, (javax.xml.rpc.handler.MessageContext)messageContext);
            return interceptorStack.invoke((javax.xml.rpc.handler.MessageContext)messageContext, params);
        }
        if (messageContext instanceof MessageContext) {
            AddressingSupport wsaSupport = NoAddressingSupport.INSTANCE;
            for (int i = 2; i < args.length; ++i) {
                if (!(args[i] instanceof AddressingSupport)) continue;
                wsaSupport = (AddressingSupport)args[i];
            }
            ThreadContext.getThreadContext().set(AddressingSupport.class, wsaSupport);
            ThreadContext.getThreadContext().set(MessageContext.class, (MessageContext)messageContext);
            return interceptorStack.invoke((MessageContext)messageContext, params);
        }
        throw new IllegalArgumentException("Uknown MessageContext type: " + messageContext.getClass().getName());
    }

    protected ProxyInfo createEJBObject(BeanContext beanContext, Method callMethod) {
        return new ProxyInfo(beanContext, null);
    }
}

