/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PerformanceTimer;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;
import org.apache.xbean.finder.filter.PatternFilter;
import org.apache.xbean.finder.filter.PrefixFilter;

public class NewLoaderLogic {
    private static final Logger logger = DeploymentLoader.logger;
    public static final String DEFAULT_EXCLUSIONS_ALIAS = "default-list";
    public static final String ADDITIONAL_EXCLUDES = SystemInstance.get().getOptions().get("openejb.additional.exclude", (String)null);
    public static final String ADDITIONAL_INCLUDE = SystemInstance.get().getOptions().get("openejb.additional.include", (String)null);
    public static final String EXCLUSION_FILE = "exclusions.list";
    private static String[] exclusions;
    private static Filter filter;

    public static UrlSet filterArchives(Filter filter, ClassLoader classLoader, UrlSet urlSet) {
        for (URL url : urlSet.getUrls()) {
            for (Archive archive : ClasspathArchive.archives((ClassLoader)classLoader, (URL[])new URL[]{url})) {
                FilteredArchive filtered = new FilteredArchive(archive, filter);
                if (filtered.iterator().hasNext()) continue;
                urlSet = urlSet.exclude(url);
            }
        }
        return urlSet;
    }

    public static Set<String> callers() {
        StackTraceElement element;
        LinkedHashSet<String> callers = new LinkedHashSet<String>();
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>(Arrays.asList(new Exception().fillInStackTrace().getStackTrace()));
        Filter start = Filters.classes((String[])new String[]{"javax.ejb.embeddable.EJBContainer", "javax.naming.InitialContext"});
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            element = (StackTraceElement)iterator.next();
            iterator.remove();
            if (!start.accept(element.getClassName())) continue;
            while (iterator.hasNext() && element.getClassName().equals(((StackTraceElement)iterator.next()).getClassName())) {
                iterator.remove();
            }
            break block0;
        }
        Filter end = Filters.packages((String[])new String[]{"junit.", "org.junit.", "org.testng.", "org.apache.maven.", "org.eclipse.", "com.intellij.", "org.scalatest."});
        Iterator i$ = elements.iterator();
        while (i$.hasNext() && !end.accept((element = (StackTraceElement)i$.next()).getClassName())) {
            callers.add(element.getClassName());
        }
        elements.clear();
        Filter unwanted = Filters.packages((String[])new String[]{"java.", "javax.", "sun.reflect."});
        Iterator classes = callers.iterator();
        while (classes.hasNext()) {
            if (!unwanted.accept((String)classes.next())) continue;
            classes.remove();
        }
        return callers;
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet) throws MalformedURLException {
        return NewLoaderLogic.applyBuiltinExcludes(urlSet, null);
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet, Filter includeFilter) throws MalformedURLException {
        return NewLoaderLogic.applyBuiltinExcludes(urlSet, includeFilter, null);
    }

    public static boolean skip(URL url) {
        return NewLoaderLogic.skip(url, null, null);
    }

    public static boolean skip(URL url, Filter includeFilter, Filter excludeFilter) {
        if ("archive".equals(url.getProtocol())) {
            return true;
        }
        try {
            File file = URLs.toFile(url);
            String name = NewLoaderLogic.filter(file).getName();
            if (includeFilter == null || !includeFilter.accept(name)) {
                if (filter != null && filter.accept(name)) {
                    return true;
                }
                if (excludeFilter != null && excludeFilter.accept(name)) {
                    return true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet, Filter includeFilter, Filter excludeFilter) throws MalformedURLException {
        NewLoaderLogic.getExclusions();
        List urls = urlSet.getUrls();
        Iterator iterator = urls.iterator();
        while (iterator.hasNext()) {
            URL url = (URL)iterator.next();
            if (!NewLoaderLogic.skip(url, includeFilter, excludeFilter)) continue;
            iterator.remove();
        }
        return new UrlSet((Collection)urls);
    }

    public static void setExclusions(String[] exclusionArray) {
        exclusions = exclusionArray;
        filter = null;
        NewLoaderLogic.getFilter();
        NewLoaderLogic.logExclusions(exclusionArray);
    }

    private static void logExclusions(String[] exclusionArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("Exclusion prefixes: [");
            for (String ex : exclusionArray) {
                logger.debug("-" + ex);
            }
            logger.debug("]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getExclusions() {
        if (exclusions != null) {
            return exclusions;
        }
        FileInputStream fis = null;
        try {
            File exclusionsFile = SystemInstance.get().getConf(EXCLUSION_FILE);
            if (exclusionsFile != null && exclusionsFile.exists()) {
                fis = new FileInputStream(exclusionsFile);
                exclusions = NewLoaderLogic.readInputStreamList(fis);
                logger.info("Loaded classpath exclusions from: " + exclusionsFile.getAbsolutePath());
            }
        }
        catch (Throwable e) {
        }
        finally {
            IO.close(fis);
        }
        if (exclusions == null) {
            exclusions = NewLoaderLogic.readDefaultExclusions();
        }
        ArrayList<String> excludes = new ArrayList<String>(exclusions.length + 5);
        excludes.addAll(Arrays.asList(exclusions));
        if (ADDITIONAL_EXCLUDES != null) {
            for (String exclude : ADDITIONAL_EXCLUDES.split(",")) {
                excludes.add(exclude.trim());
            }
        }
        if (ADDITIONAL_INCLUDE != null) {
            for (String rawInclude : ADDITIONAL_INCLUDE.split(",")) {
                String include = rawInclude.trim();
                Iterator excluded = excludes.iterator();
                while (excluded.hasNext()) {
                    if (!((String)excluded.next()).startsWith(include)) continue;
                    excluded.remove();
                }
            }
        }
        NewLoaderLogic.getFilter();
        String[] asArray = excludes.toArray(new String[excludes.size()]);
        NewLoaderLogic.logExclusions(asArray);
        return asArray;
    }

    public static Filter getFilter() {
        if (filter == null) {
            ArrayList<PrefixOrStringFilter> filters = new ArrayList<PrefixOrStringFilter>();
            for (String s : NewLoaderLogic.getExclusions()) {
                filters.add(new PrefixOrStringFilter(s));
            }
            filter = Filters.optimize((List[])new List[]{filters});
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readDefaultExclusions() {
        InputStream is = null;
        String[] read = null;
        try {
            is = NewLoaderLogic.class.getResourceAsStream("/default.exclusions");
            read = NewLoaderLogic.readInputStreamList(is);
            logger.debug("Loaded default.exclusions");
        }
        catch (Throwable throwable) {
        }
        finally {
            IO.close(is);
        }
        return read;
    }

    public static String sanitize(String value) {
        if (value.endsWith("*.jar")) {
            return value.substring(0, value.length() - 5);
        }
        if (value.endsWith("*")) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readInputStreamList(InputStream is) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String value = line.trim();
                if (line.startsWith("#") || value.isEmpty()) continue;
                if (DEFAULT_EXCLUSIONS_ALIAS.equals(value)) {
                    Collections.addAll(list, NewLoaderLogic.readDefaultExclusions());
                    continue;
                }
                list.add(NewLoaderLogic.sanitize(value));
            }
        }
        catch (Throwable e) {
            logger.warning("readInputStreamList: Failed to read provided stream");
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Throwable e) {}
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static File filter(File location) {
        ArrayList<String> invalid = new ArrayList<String>();
        invalid.add("classes");
        invalid.add("test-classes");
        invalid.add("target");
        invalid.add("build");
        invalid.add("dist");
        invalid.add("bin");
        while (invalid.contains(location.getName())) {
            location = location.getParentFile();
        }
        return location;
    }

    public static void _loadFromClasspath(FileUtils base, List<URL> jarList, ClassLoader classLoader) {
        IncludeExcludeFilter packageFilter;
        PerformanceTimer timer = new PerformanceTimer();
        timer.event("create filters");
        Options options = SystemInstance.get().getOptions();
        String include = "";
        String exclude = "";
        PatternFilter classpathInclude = new PatternFilter(options.get("openejb.deployments.classpath.include", ".*"));
        PatternFilter classpathExclude = new PatternFilter(options.get("openejb.deployments.classpath.exclude", ""));
        ExcludeIncludeFilter classpathFilter = new ExcludeIncludeFilter((Filter)classpathInclude, (Filter)classpathExclude);
        PatternFilter packageInclude = new PatternFilter(options.get("openejb.deployments.package.include", ".*"));
        PatternFilter packageExclude = new PatternFilter(options.get("openejb.deployments.package.exclude", ""));
        if (classpathInclude.getPattern().pattern().equals(".*") && packageInclude.getPattern().pattern().equals(".*")) {
            timer.event("callers");
            Set<String> callers = NewLoaderLogic.callers();
            timer.event("parse packages");
            callers.size();
            HashSet<String> packages = new HashSet<String>();
            for (String caller : callers) {
                Object[] parts = caller.split("\\.");
                if (parts.length > 2) {
                    parts = new String[]{parts[0], parts[1]};
                }
                packages.add(Join.join(".", parts));
            }
            Filter includes = Filters.packages((String[])packages.toArray(new String[packages.size()]));
            packageFilter = new IncludeExcludeFilter(includes, (Filter)packageExclude);
        } else {
            packageFilter = new IncludeExcludeFilter((Filter)packageInclude, (Filter)packageExclude);
        }
        timer.event("urlset");
        Set requireDescriptors = options.getAll("openejb.deployments.classpath.require.descriptor", new RequireDescriptors[]{RequireDescriptors.CLIENT});
        try {
            boolean userSuppliedClasspathFilter;
            UrlSet urlSet = new UrlSet(classLoader);
            timer.event("exclude system urls");
            urlSet = URLs.cullSystemJars(urlSet);
            timer.event("classpath filter");
            UrlSet beforeFiltering = urlSet;
            urlSet = urlSet.filter((Filter)classpathFilter);
            if (urlSet.size() == 0) {
                String message = String.format("Classpath Include/Exclude resulted in zero URLs.  There were %s possible URLs before filtering and 0 after: include=\"%s\", exclude=\"%s\"", beforeFiltering.size(), "", "");
                logger.error(message);
                logger.info("Eligible Classpath before filtering:");
                for (URL url : beforeFiltering) {
                    logger.info(String.format("   %s", url.toExternalForm()));
                }
            }
            boolean bl = userSuppliedClasspathFilter = beforeFiltering.size() != urlSet.size();
            if (!userSuppliedClasspathFilter) {
                logger.info("Applying buildin classpath excludes");
                timer.event("buildin excludes");
                urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet);
            }
            DeploymentsResolver.processUrls("NewLoaderLogic1", urlSet.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            timer.event("package filter");
            urlSet = NewLoaderLogic.filterArchives((Filter)packageFilter, classLoader, urlSet);
            timer.event("process urls");
            List urls = urlSet.getUrls();
            long begin = System.currentTimeMillis();
            DeploymentsResolver.processUrls("NewLoaderLogic2", urls, classLoader, requireDescriptors, base, jarList);
            long end = System.currentTimeMillis();
            long time = end - begin;
            timer.stop(System.out);
            UrlSet unchecked = new UrlSet(new URL[0]);
            DeploymentsResolver.processUrls("NewLoaderLogic3", unchecked.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            if (logger.isDebugEnabled()) {
                int urlCount = urlSet.getUrls().size() + unchecked.getUrls().size();
                logger.debug("URLs after filtering: " + urlCount);
                for (URL uRL : urlSet.getUrls()) {
                    logger.debug("Annotations path: " + uRL);
                }
                for (URL uRL : unchecked.getUrls()) {
                    logger.debug("Descriptors path: " + uRL);
                }
            }
            if (urls.size() == 0) {
                return;
            }
            if (time < 1000L) {
                logger.debug("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 4000L || urls.size() < 3) {
                logger.info("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 10000L) {
                logger.warning("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
                logger.warning("Consider adjusting your openejb.deployments.classpath.exclude and openejb.deployments.classpath.include settings.  Current settings: exclude='', include=''");
            } else {
                logger.fatal("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.  TOO LONG!");
                logger.fatal("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='', openejb.deployments.classpath.include=''");
                ArrayList<String> list = new ArrayList<String>();
                for (URL uRL : urls) {
                    list.add(uRL.toExternalForm());
                }
                Collections.sort(list);
                for (String string : list) {
                    logger.info("Matched: " + string);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.warning("Unable to search classpath for modules: Received Exception: " + e1.getClass().getName() + " " + e1.getMessage(), e1);
        }
    }

    private static class PrefixOrStringFilter
    extends PrefixFilter {
        protected final String simplePrefix;

        public PrefixOrStringFilter(String s) {
            super(s);
            this.simplePrefix = s.endsWith("-") ? s.substring(0, s.length() - 1) : s;
        }

        public boolean accept(String name) {
            return super.accept(name) || name.endsWith(".jar") && name.substring(0, name.length() - ".jar".length()).equals(this.simplePrefix);
        }
    }
}

