/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.DelegatePermissionCollection;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.MethodAttributeInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.assembler.classic.MethodPermissionInfo;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.openejb.assembler.classic.SecurityRoleReferenceInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class JaccPermissionsBuilder {
    private static final Logger log;

    public void install(PolicyContext policyContext) throws OpenEJBException {
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            return;
        }
        try {
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration policy = factory.getPolicyConfiguration(policyContext.getContextID(), false);
            policy.addToExcludedPolicy(policyContext.getExcludedPermissions());
            policy.addToUncheckedPolicy(policyContext.getUncheckedPermissions());
            for (Map.Entry<String, PermissionCollection> entry : policyContext.getRolePermissions().entrySet()) {
                policy.addToRole(entry.getKey(), entry.getValue());
            }
            policy.commit();
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("PolicyConfigurationFactory class not found", e);
        }
        catch (PolicyContextException e) {
            throw new OpenEJBException("JACC PolicyConfiguration failed: ContextId=" + policyContext.getContextID(), e);
        }
    }

    public PolicyContext build(EjbJarInfo ejbJar, HashMap<String, BeanContext> deployments) throws OpenEJBException {
        ArrayList<MethodPermissionInfo> normalized = new ArrayList<MethodPermissionInfo>();
        List<MethodPermissionInfo> perms = ejbJar.methodPermissions;
        for (MethodInfo info : ejbJar.excludeList) {
            MethodPermissionInfo perm = new MethodPermissionInfo();
            perm.excluded = true;
            perm.methods.add(info);
            perms.add(perm);
        }
        perms = MethodInfoUtil.normalizeMethodPermissionInfos(perms);
        for (BeanContext beanContext : deployments.values()) {
            Method method;
            Map<Method, MethodAttributeInfo> attributes = MethodInfoUtil.resolveAttributes(perms, beanContext);
            if (log.isDebugEnabled()) {
                for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
                    method = entry.getKey();
                    MethodPermissionInfo value = (MethodPermissionInfo)entry.getValue();
                    log.debug("Security Attribute: " + method + " -- " + MethodInfoUtil.toString(value));
                }
            }
            for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
                method = entry.getKey();
                MethodPermissionInfo a = (MethodPermissionInfo)entry.getValue();
                MethodPermissionInfo b = new MethodPermissionInfo();
                b.excluded = a.excluded;
                b.unchecked = a.unchecked;
                b.roleNames.addAll(a.roleNames);
                MethodInfo am = (MethodInfo)a.methods.get(0);
                MethodInfo bm = new MethodInfo();
                bm.ejbName = beanContext.getEjbName();
                bm.ejbDeploymentId = String.valueOf(beanContext.getDeploymentID());
                bm.methodIntf = am.methodIntf;
                bm.className = method.getDeclaringClass().getName();
                bm.methodName = method.getName();
                bm.methodParams = new ArrayList<String>();
                for (Class<?> type : method.getParameterTypes()) {
                    bm.methodParams.add(type.getName());
                }
                b.methods.add(bm);
                normalized.add(b);
            }
        }
        ejbJar.methodPermissions.clear();
        ejbJar.methodPermissions.addAll(normalized);
        ejbJar.excludeList.clear();
        PolicyContext policyContext = new PolicyContext(ejbJar.moduleUri.toString());
        for (EnterpriseBeanInfo enterpriseBean : ejbJar.enterpriseBeans) {
            BeanContext beanContext = deployments.get(enterpriseBean.ejbDeploymentId);
            PermissionCollection permissions = DelegatePermissionCollection.getPermissionCollection();
            String ejbName = enterpriseBean.ejbName;
            for (InterfaceType type : InterfaceType.values()) {
                if (type == InterfaceType.UNKNOWN) continue;
                for (Class interfce : beanContext.getInterfaces(type)) {
                    this.addPossibleEjbMethodPermissions(permissions, ejbName, type.getSpecName(), interfce);
                }
            }
            this.addPossibleEjbMethodPermissions(permissions, ejbName, null, beanContext.getBeanClass());
            this.addDeclaredEjbPermissions(ejbJar, enterpriseBean, null, permissions, policyContext);
        }
        return policyContext;
    }

    private void addDeclaredEjbPermissions(EjbJarInfo ejbJar, EnterpriseBeanInfo beanInfo, String defaultRole, PermissionCollection notAssigned, PolicyContext policyContext) throws OpenEJBException {
        PermissionCollection permissions;
        PermissionCollection uncheckedPermissions = policyContext.getUncheckedPermissions();
        PermissionCollection excludedPermissions = policyContext.getExcludedPermissions();
        Map<String, PermissionCollection> rolePermissions = policyContext.getRolePermissions();
        String ejbName = beanInfo.ejbName;
        for (MethodPermissionInfo methodPermission : ejbJar.methodPermissions) {
            List<String> roleNames = methodPermission.roleNames;
            boolean unchecked = methodPermission.unchecked;
            boolean excluded = methodPermission.excluded;
            for (MethodInfo method : methodPermission.methods) {
                String[] methodParams;
                if (!ejbName.equals(method.ejbName)) continue;
                String methodName = method.methodName;
                if ("*".equals(methodName)) {
                    methodName = null;
                }
                String methodIntf = method.methodIntf;
                if (method.methodParams != null) {
                    List<String> paramList = method.methodParams;
                    methodParams = paramList.toArray(new String[paramList.size()]);
                } else {
                    methodParams = null;
                }
                EJBMethodPermission permission = new EJBMethodPermission(ejbName, methodName, methodIntf, methodParams);
                notAssigned = this.cullPermissions(notAssigned, (Permission)permission);
                if (unchecked) {
                    uncheckedPermissions.add((Permission)permission);
                    continue;
                }
                if (excluded) {
                    excludedPermissions.add((Permission)permission);
                    continue;
                }
                for (String roleName : roleNames) {
                    PermissionCollection permissions2 = rolePermissions.get(roleName);
                    if (permissions2 == null) {
                        permissions2 = DelegatePermissionCollection.getPermissionCollection();
                        rolePermissions.put(roleName, permissions2);
                    }
                    permissions2.add((Permission)permission);
                }
            }
        }
        for (SecurityRoleReferenceInfo securityRoleRef : beanInfo.securityRoleReferences) {
            if (securityRoleRef.roleLink == null) {
                throw new OpenEJBException("Missing role-link");
            }
            String roleLink = securityRoleRef.roleLink;
            PermissionCollection roleLinks = rolePermissions.get(roleLink);
            if (roleLinks == null) {
                roleLinks = DelegatePermissionCollection.getPermissionCollection();
                rolePermissions.put(roleLink, roleLinks);
            }
            roleLinks.add((Permission)new EJBRoleRefPermission(ejbName, securityRoleRef.roleName));
        }
        if (defaultRole == null) {
            permissions = uncheckedPermissions;
        } else {
            permissions = rolePermissions.get(defaultRole);
            if (permissions == null) {
                permissions = DelegatePermissionCollection.getPermissionCollection();
                rolePermissions.put(defaultRole, permissions);
            }
        }
        Enumeration<Permission> e = notAssigned.elements();
        while (e.hasMoreElements()) {
            Permission p = e.nextElement();
            permissions.add(p);
        }
    }

    public void addPossibleEjbMethodPermissions(PermissionCollection permissions, String ejbName, String methodInterface, Class clazz) throws OpenEJBException {
        if (clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            String methodIface = "LocalBean".equals(methodInterface) || "LocalBeanHome".equals(methodInterface) ? null : methodInterface;
            permissions.add((Permission)new EJBMethodPermission(ejbName, methodIface, method));
        }
    }

    private PermissionCollection cullPermissions(PermissionCollection toBeChecked, Permission permission) {
        PermissionCollection result = DelegatePermissionCollection.getPermissionCollection();
        Enumeration<Permission> e = toBeChecked.elements();
        while (e.hasMoreElements()) {
            Permission test = e.nextElement();
            if (permission.implies(test)) continue;
            result.add(test);
        }
        return result;
    }

    static {
        System.setProperty("org.apache.security.jacc.EJBMethodPermission.methodInterfaces", "BusinessLocalHome,BusinessRemoteHome,BusinessRemote,BusinessLocal");
        log = Logger.getInstance(LogCategory.OPENEJB_STARTUP.createChild("attributes"), JaccPermissionsBuilder.class);
    }
}

