/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.report;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.api.stream.AbstractStreamDecoder;

public enum RunMode {
    NORMAL_RUN("normal-run"),
    RERUN_TEST_AFTER_FAILURE("rerun-test-after-failure");

    public static final Map<AbstractStreamDecoder.Segment, RunMode> RUN_MODES;
    private final String runmode;
    private final byte[] runmodeBinary;

    private RunMode(String runmode) {
        this.runmode = runmode;
        this.runmodeBinary = runmode.getBytes(StandardCharsets.US_ASCII);
    }

    public String geRunmode() {
        return this.runmode;
    }

    public byte[] getRunmodeBinary() {
        return this.runmodeBinary;
    }

    private static Map<AbstractStreamDecoder.Segment, RunMode> segmentsToRunModes() {
        HashMap<AbstractStreamDecoder.Segment, RunMode> runModes = new HashMap<AbstractStreamDecoder.Segment, RunMode>();
        for (RunMode runMode : RunMode.values()) {
            byte[] array = runMode.getRunmodeBinary();
            runModes.put(new AbstractStreamDecoder.Segment(array, 0, array.length), runMode);
        }
        return runModes;
    }

    static {
        RUN_MODES = RunMode.segmentsToRunModes();
    }
}

