/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.suite.SuiteDefinition;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class Surefire {
    private static final int SUCCESS = 0;
    private static final int NO_TESTS = 254;
    private static final int FAILURE = 255;
    public static final String SUREFIRE_BUNDLE_NAME = "org.apache.maven.surefire.surefire";

    public boolean run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinition, testSetName, surefireClassLoader, testsClassLoader, null, Boolean.FALSE) == 0;
    }

    public int run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Boolean failIfNoTests) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinition, testSetName, surefireClassLoader, testsClassLoader, null, failIfNoTests);
    }

    public boolean run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Properties results) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinition, testSetName, surefireClassLoader, testsClassLoader, results, Boolean.FALSE) == 0;
    }

    public int run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Properties results, Boolean failIfNoTests) throws ReporterException, TestSetFailedException {
        ReporterManagerFactory reporterManagerFactory = new ReporterManagerFactory(reportDefinitions, surefireClassLoader);
        SuiteDefinition suiteDefinition = SuiteDefinition.fromBooterFormat(Collections.singletonList(testSuiteDefinition));
        RunStatistics runStatistics = reporterManagerFactory.getGlobalRunStatistics();
        if (results != null) {
            runStatistics.initResultsFromProperties(results);
        }
        int totalTests = 0;
        SurefireTestSuite suite = this.createSuiteFromDefinition(suiteDefinition, surefireClassLoader, testsClassLoader);
        int testCount = suite.getNumTests();
        if (testCount > 0) {
            totalTests += testCount;
        }
        if (totalTests == 0) {
            reporterManagerFactory.createReporterManager().writeMessage("There are no tests to run.");
        } else {
            suite.execute(testSetName, reporterManagerFactory, testsClassLoader);
        }
        reporterManagerFactory.close();
        if (results != null) {
            runStatistics.updateResultsProperties(results);
        }
        if (failIfNoTests.booleanValue() && runStatistics.getCompletedCount() == 0) {
            return 254;
        }
        return runStatistics.isProblemFree() ? 0 : 255;
    }

    public boolean run(List reportDefinitions, List testSuiteDefinitions, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinitions, surefireClassLoader, testsClassLoader, Boolean.FALSE) == 0;
    }

    public int run(List reportDefinitions, List testSuiteDefinitions, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Boolean failIfNoTests) throws ReporterException, TestSetFailedException {
        ReporterManagerFactory reporterManagerFactory = new ReporterManagerFactory(reportDefinitions, surefireClassLoader);
        RunStatistics runStatistics = reporterManagerFactory.getGlobalRunStatistics();
        int totalTests = 0;
        SuiteDefinition definition = SuiteDefinition.fromBooterFormat(testSuiteDefinitions);
        SurefireTestSuite suite = this.createSuiteFromDefinition(definition, surefireClassLoader, testsClassLoader);
        int testCount = suite.getNumTests();
        if (testCount > 0) {
            totalTests += testCount;
        }
        if (totalTests == 0) {
            reporterManagerFactory.createReporterManager().writeMessage("There are no tests to run.");
        } else {
            suite.execute(reporterManagerFactory, testsClassLoader);
        }
        reporterManagerFactory.close();
        if (failIfNoTests.booleanValue() && runStatistics.getCompletedCount() == 0) {
            return 254;
        }
        return runStatistics.isProblemFree() ? 0 : 255;
    }

    private SurefireTestSuite createSuiteFromDefinition(SuiteDefinition definition, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) throws TestSetFailedException {
        SurefireTestSuite suite = definition.newInstance(surefireClassLoader);
        suite.locateTestSets(testsClassLoader);
        if (this.isJunit4UpgradeCheck() && suite.getClassesSkippedByValidation().size() > 0 && suite.getClass().getName().equals("org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite")) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            Iterator i = suite.getClassesSkippedByValidation().iterator();
            while (i.hasNext()) {
                Class testClass = (Class)i.next();
                reason.append("   ");
                reason.append(testClass.getCanonicalName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
        return suite;
    }

    private boolean isJunit4UpgradeCheck() {
        String property = System.getProperty("surefire.junit4.upgradecheck");
        return property != null;
    }
}

