/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.RunReporter;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.SystemStreamCapturer;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.SurefireReflectionException;

public class ReporterManagerFactory
implements ReporterFactory {
    protected final List reportDefinitions;
    protected final ClassLoader surefireClassLoader;
    protected final RunStatistics globalRunStatistics = new RunStatistics();
    private final ReporterConfiguration reporterConfiguration;
    protected RunReporter first;
    protected final Object lock = new Object();
    private final SystemStreamCapturer systemStreamCapturer = new SystemStreamCapturer();
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ReporterConfiguration;

    public ReporterManagerFactory(List reportDefinitions, ClassLoader surefireClassLoader, ReporterConfiguration reporterConfiguration) {
        this.reportDefinitions = reportDefinitions;
        this.surefireClassLoader = surefireClassLoader;
        this.reporterConfiguration = reporterConfiguration;
    }

    public ReporterManagerFactory(ClassLoader surefireClassLoader, ReporterConfiguration reporterConfiguration) {
        this(reporterConfiguration.getReports(), surefireClassLoader, reporterConfiguration);
    }

    public RunStatistics getGlobalRunStatistics() {
        return this.globalRunStatistics;
    }

    public ReporterManager createReporterManager() {
        List reports = this.instantiateReports(this.reportDefinitions, this.surefireClassLoader);
        return (ReporterManager)this.setupReporter(reports);
    }

    public Reporter createReporter() {
        List reports = this.instantiateReportsNewStyle(this.reportDefinitions, this.reporterConfiguration, this.surefireClassLoader);
        return this.setupReporter(reports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reporter setupReporter(List reports) {
        ReporterManager reporterManager = new ReporterManager(reports, this.globalRunStatistics, this.systemStreamCapturer);
        if (this.first == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.first == null) {
                    this.first = reporterManager;
                    reporterManager.runStarting();
                }
            }
        }
        return reporterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult close() {
        this.warnIfNoTests();
        Object object = this.lock;
        synchronized (object) {
            if (this.first != null) {
                this.first.runCompleted();
            }
            return this.globalRunStatistics.getRunResult();
        }
    }

    private List instantiateReports(List reportDefinitions, ClassLoader classLoader) {
        if (reportDefinitions.size() == 0) {
            return new ArrayList();
        }
        return this.instantiateReportsNewStyle(reportDefinitions, this.reporterConfiguration, classLoader);
    }

    protected List instantiateReportsNewStyle(List reportDefinitions, ReporterConfiguration reporterConfiguration, ClassLoader classLoader) {
        ArrayList<Reporter> reports = new ArrayList<Reporter>();
        Iterator i = reportDefinitions.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            Reporter report = ReporterManagerFactory.instantiateReportNewStyle(className, reporterConfiguration, classLoader);
            reports.add(report);
        }
        return reports;
    }

    private static Reporter instantiateReportNewStyle(String className, ReporterConfiguration params, ClassLoader classLoader) {
        Class clazz = ReflectionUtils.loadClass(classLoader, className);
        if (params != null) {
            Class[] paramTypes = new Class[]{ReflectionUtils.loadClass(classLoader, (class$org$apache$maven$surefire$report$ReporterConfiguration == null ? (class$org$apache$maven$surefire$report$ReporterConfiguration = ReporterManagerFactory.class$("org.apache.maven.surefire.report.ReporterConfiguration")) : class$org$apache$maven$surefire$report$ReporterConfiguration).getName())};
            Constructor constructor = ReflectionUtils.getConstructor(clazz, paramTypes);
            return (Reporter)ReflectionUtils.newInstance(constructor, new Object[]{params});
        }
        try {
            return (Reporter)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new SurefireReflectionException(e);
        }
    }

    private void warnIfNoTests() {
        if (this.getGlobalRunStatistics().getRunResult().getCompletedCount() == 0) {
            this.createReporterManager().writeMessage("There are no tests to run.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

