/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.Properties;

public class TestSetStatistics {
    private static final String RESULTS_ERRORS = "errors";
    private static final String RESULTS_COMPLETED_COUNT = "completedCount";
    private static final String RESULTS_FAILURES = "failures";
    private static final String RESULTS_SKIPPED = "skipped";
    protected int completedCount;
    protected int errors;
    protected int failures;
    protected int skipped;

    public synchronized void incrementCompletedCount() {
        ++this.completedCount;
    }

    public synchronized void incrementErrorsCount() {
        ++this.errors;
    }

    public synchronized void incrementFailureCount() {
        ++this.failures;
    }

    public synchronized void incrementSkippedCount() {
        ++this.skipped;
    }

    public synchronized boolean isProblemFree() {
        return !this.hadFailures() && !this.hadErrors();
    }

    public synchronized boolean hadFailures() {
        return this.failures > 0;
    }

    public synchronized boolean hadErrors() {
        return this.errors > 0;
    }

    public synchronized int getCompletedCount() {
        return this.completedCount;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public synchronized void initResultsFromProperties(Properties results) {
        this.errors = Integer.valueOf(results.getProperty(RESULTS_ERRORS, "0"));
        this.skipped = Integer.valueOf(results.getProperty(RESULTS_SKIPPED, "0"));
        this.failures = Integer.valueOf(results.getProperty(RESULTS_FAILURES, "0"));
        this.completedCount = Integer.valueOf(results.getProperty(RESULTS_COMPLETED_COUNT, "0"));
    }

    public synchronized void updateResultsProperties(Properties results) {
        results.setProperty(RESULTS_ERRORS, String.valueOf(this.errors));
        results.setProperty(RESULTS_COMPLETED_COUNT, String.valueOf(this.completedCount));
        results.setProperty(RESULTS_FAILURES, String.valueOf(this.failures));
        results.setProperty(RESULTS_SKIPPED, String.valueOf(this.skipped));
    }

    public synchronized String getSummary() {
        return "Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Skipped: " + this.skipped;
    }
}

