/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.DirectoryScanner;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.StringUtils;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class SurefireDirectoryScanner {
    private static final String FS = System.getProperty("file.separator");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final File basedir;
    private final List includes;
    private final List excludes;
    protected Map testSets;
    private int totalTests;

    public Map getTestSets() {
        return this.testSets;
    }

    public SurefireDirectoryScanner(File basedir, List includes, List excludes) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
    }

    public Map locateTestSets(ClassLoader classLoader, TestSetCreator testSetCreator) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new HashMap();
        Class[] locatedClasses = this.locateTestClasses(classLoader);
        for (int i = 0; i < locatedClasses.length; ++i) {
            Class testClass = locatedClasses[i];
            SurefireTestSet testSet = testSetCreator.createTestSet(testClass);
            if (testSet == null) continue;
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
            ++this.totalTests;
        }
        return Collections.unmodifiableMap(this.testSets);
    }

    public Class[] locateTestClasses(ClassLoader classLoader) throws TestSetFailedException {
        String[] testClassNames = this.collectTests();
        ArrayList result = new ArrayList();
        for (int i = 0; i < testClassNames.length; ++i) {
            Class<?> testClass;
            String className = testClassNames[i];
            try {
                testClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new TestSetFailedException("Unable to create test class '" + className + "'", e);
            }
            if (Modifier.isAbstract(testClass.getModifiers())) continue;
            result.add(testClass);
        }
        return result.toArray(new Class[result.size()]);
    }

    String[] collectTests() {
        String[] tests = EMPTY_STRING_ARRAY;
        if (this.basedir.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.basedir);
            if (this.includes != null) {
                scanner.setIncludes(SurefireDirectoryScanner.processIncludesExcludes(this.includes));
            }
            if (this.excludes != null) {
                scanner.setExcludes(SurefireDirectoryScanner.processIncludesExcludes(this.excludes));
            }
            scanner.scan();
            tests = scanner.getIncludedFiles();
            for (int i = 0; i < tests.length; ++i) {
                String test = tests[i];
                test = test.substring(0, test.indexOf("."));
                tests[i] = test.replace(FS.charAt(0), '.');
            }
        }
        return tests;
    }

    private static String[] processIncludesExcludes(List list) {
        String[] incs = new String[list.size()];
        for (int i = 0; i < incs.length; ++i) {
            incs[i] = StringUtils.replace((String)list.get(i), "java", "class");
        }
        return incs;
    }

    public static interface TestSetCreator {
        public SurefireTestSet createTestSet(Class var1);
    }
}

