/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.vss.commands.update;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.vss.commands.VssCommandLineUtils;
import org.apache.maven.scm.provider.vss.commands.changelog.VssHistoryCommand;
import org.apache.maven.scm.provider.vss.commands.update.VssUpdateConsumer;
import org.apache.maven.scm.provider.vss.repository.VssScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class VssUpdateCommand
extends AbstractUpdateCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        this.getLogger().debug("executing update command...");
        VssScmProviderRepository repo = (VssScmProviderRepository)repository;
        Commandline cl = this.buildCmdLine(repo, fileSet, version);
        VssUpdateConsumer consumer = new VssUpdateConsumer(repo, this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
        int exitCode = VssCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            String error = stderr.getOutput();
            this.getLogger().debug("VSS returns error: [" + error + "] return code: [" + exitCode + "]");
            if (error.indexOf("A writable copy of") < 0) {
                return new UpdateScmResult(cl.toString(), "The vss command failed.", error, false);
            }
            this.getLogger().warn(error);
        }
        return new UpdateScmResult(cl.toString(), consumer.getUpdatedFiles());
    }

    public Commandline buildCmdLine(VssScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        try {
            command.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new ScmException("Can't add system environment.", (Throwable)e);
        }
        command.addEnvironment("SSDIR", repo.getVssdir());
        String ssDir = VssCommandLineUtils.getSsDir();
        command.setExecutable(ssDir + "ss");
        command.createArgument().setValue("Get");
        command.createArgument().setValue("$" + repo.getProject());
        if (repo.getUserPassword() != null) {
            command.createArgument().setValue("-Y" + repo.getUserPassword());
        }
        command.createArgument().setValue("-R");
        command.createArgument().setValue("-I-");
        command.createArgument().setValue("-GWS");
        return command;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        VssHistoryCommand command = new VssHistoryCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

