/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.untag;

import java.util.Collection;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmUntagParameters;
import org.apache.maven.scm.command.untag.AbstractUntagCommand;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class JGitUntagCommand
extends AbstractUntagCommand
implements GitCommand {
    protected ScmResult executeUntagCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmUntagParameters scmUntagParameters) throws ScmException {
        String tagName = scmUntagParameters.getTag();
        if (tagName == null || tagName.trim().isEmpty()) {
            throw new ScmException("tag name must be specified");
        }
        String escapedTagName = tagName.trim().replace(' ', '_');
        Git git = null;
        try {
            UntagScmResult refSpec;
            git = JGitUtils.openRepo(fileSet.getBasedir());
            if (git.tagDelete().setTags(new String[]{escapedTagName}).call().isEmpty()) {
                UntagScmResult untagScmResult = new UntagScmResult("JGit tagDelete", "Failed to delete tag", "", false);
                return untagScmResult;
            }
            if (repository.isPushChanges()) {
                refSpec = new RefSpec().setSource(null).setDestination("refs/tags/" + escapedTagName);
                this.logger.info("push delete tag [" + escapedTagName + "] to remote...");
                Iterable<PushResult> pushResultList = JGitUtils.push(git, (GitScmProviderRepository)repository, (RefSpec)refSpec);
                if (this.logger.isInfoEnabled()) {
                    for (PushResult pushResult : pushResultList) {
                        Collection ru = pushResult.getRemoteUpdates();
                        for (RemoteRefUpdate remoteRefUpdate : ru) {
                            this.logger.info(remoteRefUpdate.getStatus() + " - " + remoteRefUpdate);
                        }
                    }
                }
            }
            refSpec = new UntagScmResult("JGit tagDelete");
            return refSpec;
        }
        catch (Exception e) {
            throw new ScmException("JGit tagDelete failure!", (Throwable)e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

