/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.HgConfig;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.inventory.HgChangeSet;
import org.apache.maven.scm.provider.hg.command.inventory.HgOutgoingConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class HgUtils {
    public static final String DEFAULT = "default";
    private static final Map<String, List<Integer>> EXIT_CODE_MAP = new HashMap<String, List<Integer>>();
    private static final List<Integer> DEFAULT_EXIT_CODES = new ArrayList<Integer>();

    private HgUtils() {
    }

    public static ScmResult execute(HgConsumer consumer, ScmLogger logger, File workingDir, String[] cmdAndArgs) throws ScmException {
        try {
            Commandline cmd = HgUtils.buildCmd(workingDir, cmdAndArgs);
            if (logger.isInfoEnabled()) {
                logger.info("EXECUTING: " + HgUtils.maskPassword(cmd));
            }
            int exitCode = HgUtils.executeCmd(consumer, cmd);
            List<Integer> exitCodes = DEFAULT_EXIT_CODES;
            if (EXIT_CODE_MAP.containsKey(cmdAndArgs[0])) {
                exitCodes = EXIT_CODE_MAP.get(cmdAndArgs[0]);
            }
            boolean success = exitCodes.contains(exitCode);
            String providerMsg = "Execution of hg command succeded";
            if (!success) {
                HgConfig config = new HgConfig(workingDir);
                providerMsg = "\nEXECUTION FAILED\n  Execution of cmd : " + cmdAndArgs[0] + " failed with exit code: " + exitCode + ".\n  Working directory was: \n    " + workingDir.getAbsolutePath() + config.toString(workingDir) + "\n";
                if (logger.isErrorEnabled()) {
                    logger.error(providerMsg);
                }
            }
            return new ScmResult(cmd.toString(), providerMsg, consumer.getStdErr(), success);
        }
        catch (ScmException se) {
            String msg = "EXECUTION FAILED\n  Execution failed before invoking the Hg command. Last exception:\n    " + se.getMessage();
            if (se.getCause() != null) {
                msg = msg + "\n  Nested exception:\n    " + se.getCause().getMessage();
            }
            if (logger.isErrorEnabled()) {
                logger.error(msg);
            }
            throw se;
        }
    }

    static Commandline buildCmd(File workingDir, String[] cmdAndArgs) throws ScmException {
        Commandline cmd = new Commandline();
        cmd.setExecutable("hg");
        cmd.addArguments(cmdAndArgs);
        if (workingDir != null) {
            boolean success;
            cmd.setWorkingDirectory(workingDir.getAbsolutePath());
            if (!workingDir.exists() && !(success = workingDir.mkdirs())) {
                String msg = "Working directory did not exist and it couldn't be created: " + workingDir;
                throw new ScmException(msg);
            }
        }
        return cmd;
    }

    static int executeCmd(HgConsumer consumer, Commandline cmd) throws ScmException {
        int exitCode;
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)consumer, (StreamConsumer)consumer);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Command could not be executed: " + cmd, (Throwable)ex);
        }
        return exitCode;
    }

    public static ScmResult execute(File workingDir, String[] cmdAndArgs) throws ScmException {
        DefaultLog logger = new DefaultLog();
        return HgUtils.execute(new HgConsumer((ScmLogger)logger), (ScmLogger)logger, workingDir, cmdAndArgs);
    }

    public static String[] expandCommandLine(String[] cmdAndArgs, ScmFileSet additionalFiles) {
        List filesList = additionalFiles.getFileList();
        String[] cmd = new String[filesList.size() + cmdAndArgs.length];
        System.arraycopy(cmdAndArgs, 0, cmd, 0, cmdAndArgs.length);
        int i = 0;
        for (File scmFile : filesList) {
            String file;
            cmd[i + cmdAndArgs.length] = file = scmFile.getPath().replace('\\', File.separatorChar);
            ++i;
        }
        return cmd;
    }

    public static int getCurrentRevisionNumber(ScmLogger logger, File workingDir) throws ScmException {
        String[] revCmd = new String[]{"id"};
        HgRevNoConsumer consumer = new HgRevNoConsumer(logger);
        HgUtils.execute(consumer, logger, workingDir, revCmd);
        return consumer.getCurrentRevisionNumber();
    }

    public static String getCurrentBranchName(ScmLogger logger, File workingDir) throws ScmException {
        String[] branchnameCmd = new String[]{"branch"};
        HgBranchnameConsumer consumer = new HgBranchnameConsumer(logger);
        HgUtils.execute(consumer, logger, workingDir, branchnameCmd);
        return consumer.getBranchName();
    }

    public static boolean differentOutgoingBranchFound(ScmLogger logger, File workingDir, String workingbranchName) throws ScmException {
        String[] outCmd = new String[]{"outgoing"};
        HgOutgoingConsumer outConsumer = new HgOutgoingConsumer(logger);
        ScmResult outResult = HgUtils.execute(outConsumer, logger, workingDir, outCmd);
        List<HgChangeSet> changes = outConsumer.getChanges();
        if (outResult.isSuccess()) {
            for (HgChangeSet set : changes) {
                if (HgUtils.getBranchName(workingbranchName).equals(HgUtils.getBranchName(set.getBranch()))) continue;
                logger.warn("A different branch than " + HgUtils.getBranchName(workingbranchName) + " was found in outgoing changes, branch name was " + HgUtils.getBranchName(set.getBranch()) + ". Only local branch named " + HgUtils.getBranchName(workingbranchName) + " will be pushed.");
                return true;
            }
        }
        return false;
    }

    private static String getBranchName(String branch) {
        return branch == null ? DEFAULT : branch;
    }

    public static String maskPassword(Commandline cl) {
        String clString = cl.toString();
        int pos = clString.indexOf(64);
        if (pos > 0) {
            clString = clString.replaceAll(":\\w+@", ":*****@");
        }
        return clString;
    }

    static {
        DEFAULT_EXIT_CODES.add(0);
        ArrayList<Integer> diffExitCodes = new ArrayList<Integer>(3);
        diffExitCodes.add(0);
        diffExitCodes.add(1);
        diffExitCodes.add(2);
        EXIT_CODE_MAP.put("diff", diffExitCodes);
        ArrayList<Integer> outgoingExitCodes = new ArrayList<Integer>(2);
        outgoingExitCodes.add(0);
        outgoingExitCodes.add(1);
        EXIT_CODE_MAP.put("outgoing", outgoingExitCodes);
    }

    private static class HgBranchnameConsumer
    extends HgConsumer {
        private String branchName;

        HgBranchnameConsumer(ScmLogger logger) {
            super(logger);
        }

        @Override
        public void doConsume(ScmFileStatus status, String trimmedLine) {
            this.branchName = String.valueOf(trimmedLine);
        }

        String getBranchName() {
            return this.branchName;
        }

        @Override
        public void consumeLine(String line) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(line);
            }
            String trimmedLine = line.trim();
            this.doConsume(null, trimmedLine);
        }
    }

    private static class HgRevNoConsumer
    extends HgConsumer {
        private int revNo;

        HgRevNoConsumer(ScmLogger logger) {
            super(logger);
        }

        @Override
        public void doConsume(ScmFileStatus status, String line) {
            try {
                this.revNo = Integer.valueOf(line);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        int getCurrentRevisionNumber() {
            return this.revNo;
        }
    }
}

