/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.provider.git.gitexe.command.AnonymousCommandLine;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.git.util.GitUtil;
import org.apache.maven.scm.providers.gitlib.settings.Settings;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitCommandLineUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitCommandLineUtils.class);
    public static final String VARIABLE_GIT_SSH_COMMAND = "GIT_SSH_COMMAND";

    private GitCommandLineUtils() {
    }

    public static void addTarget(Commandline commandLine, List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        File workingDirectory = commandLine.getWorkingDirectory();
        try {
            String canonicalWorkingDirectory = workingDirectory.getCanonicalPath();
            for (File file : files) {
                String relativeFile = file.getPath();
                String canonicalFile = file.getCanonicalPath();
                if (canonicalFile.startsWith(canonicalWorkingDirectory) && (relativeFile = canonicalFile.substring(canonicalWorkingDirectory.length())).startsWith(File.separator)) {
                    relativeFile = relativeFile.substring(File.separator.length());
                }
                commandLine.createArg().setValue(FilenameUtils.separatorsToUnix((String)relativeFile));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not get canonical paths for workingDirectory = " + workingDirectory + " or files=" + files, ex);
        }
    }

    public static Commandline getBaseGitCommandLine(File workingDirectory, String command) {
        return GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, command, null, null);
    }

    public static Commandline getBaseGitCommandLine(File workingDirectory, String command, GitScmProviderRepository repository, Map<String, String> environment) {
        Commandline commandLine = GitCommandLineUtils.getAnonymousBaseGitCommandLine(workingDirectory, command);
        if (repository != null) {
            GitCommandLineUtils.prepareEnvVariablesForRepository(repository, environment).forEach((arg_0, arg_1) -> ((Commandline)commandLine).addEnvironment(arg_0, arg_1));
        } else if (environment != null) {
            environment.forEach((arg_0, arg_1) -> ((Commandline)commandLine).addEnvironment(arg_0, arg_1));
        }
        return commandLine;
    }

    private static Commandline getAnonymousBaseGitCommandLine(File workingDirectory, String command) {
        if (command == null || command.isEmpty()) {
            return null;
        }
        AnonymousCommandLine commandLine = new AnonymousCommandLine();
        GitCommandLineUtils.composeCommand(workingDirectory, command, commandLine);
        return commandLine;
    }

    private static void composeCommand(File workingDirectory, String command, Commandline commandLine) {
        Settings settings = GitUtil.getSettings();
        commandLine.setExecutable(settings.getGitCommand());
        commandLine.createArg().setValue(command);
        if (workingDirectory != null) {
            commandLine.setWorkingDirectory(workingDirectory.getAbsolutePath());
        }
    }

    public static int execute(Commandline commandline, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr) throws ScmException {
        int exitCode;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing: " + commandline);
            LOGGER.debug("Working directory: " + commandline.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return exitCode;
    }

    public static int execute(Commandline commandLine, CommandLineUtils.StringStreamConsumer stdout, CommandLineUtils.StringStreamConsumer stderr) throws ScmException {
        int exitCode;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing: " + commandLine);
            LOGGER.debug("Working directory: " + commandLine.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return exitCode;
    }

    static Map<String, String> prepareEnvVariablesForRepository(GitScmProviderRepository repository, Map<String, String> environmentVariables) {
        HashMap<String, String> effectiveEnvironmentVariables = new HashMap<String, String>();
        if (environmentVariables != null) {
            effectiveEnvironmentVariables.putAll(environmentVariables);
        }
        if (StringUtils.isNotBlank((CharSequence)repository.getPrivateKey()) && effectiveEnvironmentVariables.putIfAbsent(VARIABLE_GIT_SSH_COMMAND, "ssh -o IdentitiesOnly=yes -i " + FilenameUtils.separatorsToUnix((String)repository.getPrivateKey())) != null) {
            LOGGER.warn("Ignore GitScmProviderRepository.privateKey as environment variable {} is already set", (Object)VARIABLE_GIT_SSH_COMMAND);
        }
        if (StringUtils.isNotBlank((CharSequence)repository.getPassphrase())) {
            LOGGER.warn("GitScmProviderRepository.passphrase currently not supported by provider 'git'");
        }
        return effectiveEnvironmentVariables;
    }
}

