/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.artifact.Artifact;

public class Overlay {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    public static final String[] DEFAULT_EXCLUDES = new String[]{"META-INF/MANIFEST.MF"};
    private static Overlay currentProjectInstance;
    private String id;
    private String groupId;
    private String artifactId;
    private String classifier = null;
    private String[] includes = DEFAULT_INCLUDES;
    private String[] excludes = DEFAULT_EXCLUDES;
    private boolean filtered = false;
    private boolean skip = false;
    private Artifact artifact;
    private String targetPath;
    private String type = "war";

    public Overlay() {
    }

    public Overlay(String groupId, String artifactId) {
        this();
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public boolean isCurrentProject() {
        return this.groupId == null && this.artifactId == null;
    }

    public static Overlay currentProjectInstance() {
        if (currentProjectInstance == null) {
            currentProjectInstance = new Overlay();
            currentProjectInstance.setId("currentBuild");
        }
        return currentProjectInstance;
    }

    public String getId() {
        if (this.id == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getGroupId()).append(":").append(this.getArtifactId());
            if (this.getClassifier() != null) {
                sb.append(":").append(this.getClassifier());
            }
            this.id = sb.toString();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = this.parse(includes);
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = this.parse(excludes);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean shouldSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return " id " + this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Overlay overlay = (Overlay)o;
        if (this.excludes != null ? !Arrays.equals(this.excludes, overlay.excludes) : overlay.excludes != null) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(overlay.getId()) : overlay.getId() != null) {
            return false;
        }
        return !(this.includes != null ? !Arrays.equals(this.includes, overlay.includes) : overlay.includes != null);
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
        result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
        return result;
    }

    private String[] parse(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s == null) {
            return result.toArray(new String[result.size()]);
        }
        String[] tokens = s.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            result.add(token.trim());
        }
        return result.toArray(new String[result.size()]);
    }
}

