/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class SuperProjectSorter {
    private final DAG dag = new DAG();
    private final Map projectMap = new HashMap();
    private final List sortedProjects;
    private MavenProject topLevelProject;

    public SuperProjectSorter(List projects) throws CycleDetectedException, DuplicateProjectException {
        String id;
        MavenProject project;
        for (Object project2 : projects) {
            project = (MavenProject)project2;
            id = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            if (this.dag.getVertex(id) != null) {
                throw new DuplicateProjectException("Project '" + id + "' is duplicated in the reactor");
            }
            this.dag.addVertex(id);
            this.projectMap.put(id, project);
        }
        for (Object project1 : projects) {
            List reportPlugins;
            List buildPlugins;
            String parentId;
            project = (MavenProject)project1;
            id = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            for (Object o1 : project.getDependencies()) {
                Dependency dependency = (Dependency)o1;
                String dependencyId = ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId());
                if (this.dag.getVertex(dependencyId) == null) continue;
                project.addProjectReference((MavenProject)this.projectMap.get(dependencyId));
                this.dag.addEdge(id, dependencyId);
            }
            MavenProject parent = project.getParent();
            if (parent != null && this.dag.getVertex(parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId())) != null) {
                if (this.dag.hasEdge(parentId, id)) {
                    this.dag.removeEdge(parentId, id);
                }
                this.dag.addEdge(id, parentId);
            }
            if ((buildPlugins = project.getBuildPlugins()) != null) {
                for (Object buildPlugin : buildPlugins) {
                    Plugin plugin = (Plugin)buildPlugin;
                    String pluginId = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                    if (this.dag.getVertex(pluginId) == null || pluginId.equals(id)) continue;
                    this.addEdgeWithParentCheck(this.projectMap, pluginId, project, id);
                }
            }
            if ((reportPlugins = project.getReportPlugins()) != null) {
                for (Object reportPlugin : reportPlugins) {
                    ReportPlugin plugin = (ReportPlugin)reportPlugin;
                    String pluginId = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                    if (this.dag.getVertex(pluginId) == null || pluginId.equals(id)) continue;
                    this.addEdgeWithParentCheck(this.projectMap, pluginId, project, id);
                }
            }
            for (Object o : project.getBuildExtensions()) {
                Extension extension = (Extension)o;
                String extensionId = ArtifactUtils.versionlessKey((String)extension.getGroupId(), (String)extension.getArtifactId());
                if (this.dag.getVertex(extensionId) == null) continue;
                this.addEdgeWithParentCheck(this.projectMap, extensionId, project, id);
            }
        }
        ArrayList sortedProjects = new ArrayList();
        for (String id2 : TopologicalSorter.sort((DAG)this.dag)) {
            sortedProjects.add(this.projectMap.get(id2));
        }
        this.sortedProjects = Collections.unmodifiableList(sortedProjects);
    }

    private void addEdgeWithParentCheck(Map projectMap, String projectRefId, MavenProject project, String id) throws CycleDetectedException {
        MavenProject extProject = (MavenProject)projectMap.get(projectRefId);
        if (extProject == null) {
            return;
        }
        project.addProjectReference(extProject);
        MavenProject extParent = extProject.getParent();
        if (extParent != null) {
            String parentId = ArtifactUtils.versionlessKey((String)extParent.getGroupId(), (String)extParent.getArtifactId());
            if (!this.dag.hasEdge(projectRefId, id) || !parentId.equals(id)) {
                this.dag.addEdge(id, projectRefId);
            }
        }
    }

    public MavenProject getTopLevelProject() {
        if (this.topLevelProject == null) {
            Iterator i = this.sortedProjects.iterator();
            while (i.hasNext() && this.topLevelProject == null) {
                MavenProject project = (MavenProject)i.next();
                if (!project.isExecutionRoot()) continue;
                this.topLevelProject = project;
            }
        }
        return this.topLevelProject;
    }

    public List getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List getDependents(String id) {
        return this.dag.getParentLabels(id);
    }

    public DAG getDAG() {
        return this.dag;
    }

    public Map getProjectMap() {
        return this.projectMap;
    }
}

