/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="cim")
public class CimReport
extends AbstractProjectInfoReport {
    public void executeReport(Locale locale) {
        CimRenderer r = new CimRenderer(this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale);
        r.render();
    }

    public String getOutputName() {
        return "integration";
    }

    protected String getI18Nsection() {
        return "cim";
    }

    private static class CimRenderer
    extends AbstractProjectInfoRenderer {
        private Model model;

        CimRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
        }

        protected String getI18Nsection() {
            return "cim";
        }

        public void renderBody() {
            CiManagement cim = this.model.getCiManagement();
            if (cim == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nocim"));
                this.endSection();
                return;
            }
            String system = cim.getSystem();
            String url = cim.getUrl();
            List notifiers = cim.getNotifiers();
            this.startSection(this.getI18nString("overview.title"));
            this.sink.paragraph();
            if (this.isCimSystem(system, "anthill")) {
                this.linkPatternedText(this.getI18nString("anthill.intro"));
            } else if (this.isCimSystem(system, "bamboo")) {
                this.linkPatternedText(this.getI18nString("bamboo.intro"));
            } else if (this.isCimSystem(system, "buildforge")) {
                this.linkPatternedText(this.getI18nString("buildforge.intro"));
            } else if (this.isCimSystem(system, "continuum")) {
                this.linkPatternedText(this.getI18nString("continuum.intro"));
            } else if (this.isCimSystem(system, "cruisecontrol")) {
                this.linkPatternedText(this.getI18nString("cruisecontrol.intro"));
            } else if (this.isCimSystem(system, "hudson")) {
                this.linkPatternedText(this.getI18nString("hudson.intro"));
            } else if (this.isCimSystem(system, "jenkins")) {
                this.linkPatternedText(this.getI18nString("jenkins.intro"));
            } else if (this.isCimSystem(system, "luntbuild")) {
                this.linkPatternedText(this.getI18nString("luntbuild.intro"));
            } else {
                this.linkPatternedText(this.getI18nString("general.intro"));
            }
            this.sink.paragraph_();
            this.endSection();
            this.startSection(this.getI18nString("access"));
            if (!StringUtils.isEmpty((String)url)) {
                this.paragraph(this.getI18nString("url"));
                this.verbatimLink(url, url);
            } else {
                this.paragraph(this.getI18nString("nourl"));
            }
            this.endSection();
            this.startSection(this.getI18nString("notifiers.title"));
            if (notifiers == null || notifiers.isEmpty()) {
                this.paragraph(this.getI18nString("notifiers.nolist"));
            } else {
                this.sink.paragraph();
                this.sink.text(this.getI18nString("notifiers.intro"));
                this.sink.paragraph_();
                this.startTable();
                String type = this.getI18nString("notifiers.column.type");
                String address = this.getI18nString("notifiers.column.address");
                String configuration = this.getI18nString("notifiers.column.configuration");
                this.tableHeader(new String[]{type, address, configuration});
                for (Notifier notifier : notifiers) {
                    this.tableRow(new String[]{notifier.getType(), CimRenderer.createLinkPatternedText((String)notifier.getAddress(), (String)notifier.getAddress()), CimRenderer.propertiesToString((Properties)notifier.getConfiguration())});
                }
                this.endTable();
            }
            this.endSection();
        }

        private boolean isCimSystem(String connection, String cim) {
            if (StringUtils.isEmpty((String)connection)) {
                return false;
            }
            if (StringUtils.isEmpty((String)cim)) {
                return false;
            }
            return connection.toLowerCase(Locale.ENGLISH).startsWith(cim.toLowerCase(Locale.ENGLISH));
        }
    }
}

