/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class HelpUtil {
    protected static MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project, String invokedVia, boolean canUsePrefix, boolean isOptionalMojo) throws MojoFailureException, MojoExecutionException {
        try {
            DefaultLifecycleExecutor lifecycleExecutor = (DefaultLifecycleExecutor)session.lookup(LifecycleExecutor.ROLE);
            Method m = lifecycleExecutor.getClass().getDeclaredMethod("getMojoDescriptor", String.class, MavenSession.class, MavenProject.class, String.class, Boolean.TYPE, Boolean.TYPE);
            m.setAccessible(true);
            MojoDescriptor mojoDescriptor = (MojoDescriptor)m.invoke((Object)lifecycleExecutor, task, session, project, invokedVia, canUsePrefix, isOptionalMojo);
            if (mojoDescriptor == null) {
                throw new MojoExecutionException("No MOJO exists for '" + task + "'.");
            }
            return mojoDescriptor;
        }
        catch (SecurityException e) {
            throw new MojoFailureException("SecurityException: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("IllegalArgumentException: " + e.getMessage());
        }
        catch (ComponentLookupException e) {
            throw new MojoFailureException("ComponentLookupException: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MojoFailureException("NoSuchMethodException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MojoFailureException("IllegalAccessException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BuildFailureException) {
                throw new MojoFailureException("BuildFailureException: " + cause.getMessage());
            }
            if (cause instanceof LifecycleExecutionException) {
                throw new MojoFailureException("LifecycleExecutionException: " + cause.getMessage());
            }
            if (cause instanceof PluginNotFoundException) {
                throw new MojoFailureException("PluginNotFoundException: " + cause.getMessage());
            }
            StringWriter s = new StringWriter();
            PrintWriter writer = new PrintWriter(s);
            e.printStackTrace(writer);
            throw new MojoFailureException("InvocationTargetException: " + e.getMessage() + "\n" + s.toString());
        }
    }
}

