/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-help-plugin:2.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Help Plugin 2.1", 0);
        this.append(sb, "The Maven Help plugin provides goals aimed at helping to make sense out of the build environment. It includes the ability to view the effective POM and settings files, after inheritance and active profiles have been applied, as well as a describe a particular plugin goal to give usage information.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 9 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "active-profiles".equals(this.goal)) {
            this.append(sb, "help:active-profiles", 0);
            this.append(sb, "Displays a list of the profiles which are currently active for this build.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "all-profiles".equals(this.goal)) {
            this.append(sb, "help:all-profiles", 0);
            this.append(sb, "Displays a list of available profiles under the current project.\nNote: it will list all profiles for a project. If a profile comes up with a status inactive then there might be a need to set profile activation switches/property.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "describe".equals(this.goal)) {
            this.append(sb, "help:describe", 0);
            this.append(sb, "Displays a list of the attributes for a Maven Plugin and/or goals (aka Mojo - Maven plain Old Java Object).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactId", 2);
                this.append(sb, "The Maven Plugin artifactId to describe.\nNote: Should be used with groupId parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmd", 2);
                this.append(sb, "A Maven command like a single goal or a single phase following the Maven command line:\nmvn [options] [<goal(s)>] [<phase(s)>]", 3);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "This flag specifies that a detailed (verbose) list of goal (Mojo) information should be given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The goal name of a Mojo to describe within the specified Maven Plugin. If this parameter is specified, only the corresponding goal (Mojo) will be described, rather than the whole Plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId", 2);
                this.append(sb, "The Maven Plugin groupId to describe.\nNote: Should be used with artifactId parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "medium (Default: true)", 2);
                this.append(sb, "This flag specifies that a medium list of goal (Mojo) information should be given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "minimal (Default: false)", 2);
                this.append(sb, "This flag specifies that a minimal list of goal (Mojo) information should be given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
                this.append(sb, "plugin", 2);
                this.append(sb, "The Maven Plugin to describe. This must be specified in one of three ways:\n\n1.\tplugin-prefix, i.e. 'help'\n2.\tgroupId:artifactId, i.e. 'org.apache.maven.plugins:maven-help-plugin'\n3.\tgroupId:artifactId:version, i.e. 'org.apache.maven.plugins:maven-help-plugin:2.0'\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The Maven Plugin version to describe.\nNote: Should be used with groupId/artifactId parameters.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "effective-pom".equals(this.goal)) {
            this.append(sb, "help:effective-pom", 0);
            this.append(sb, "Displays the effective POM as an XML for this build, with the active profiles factored in.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "effective-settings".equals(this.goal)) {
            this.append(sb, "help:effective-settings", 0);
            this.append(sb, "Displays the calculated settings as XML for this project, given any profile enhancement and the inheritance of the global settings into the user-level settings.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showPasswords (Default: false)", 2);
                this.append(sb, "For security reasons, all passwords are hidden by default. Set this to true to show all passwords.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "evaluate".equals(this.goal)) {
            this.append(sb, "help:evaluate", 0);
            this.append(sb, "Evaluates Maven expressions given by the user in an interactive mode.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifact", 2);
                this.append(sb, "An artifact for evaluating Maven expressions.\nNote: Should respect the Maven format, i.e. groupId:artifactId[:version][:classifier].", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "expressions".equals(this.goal)) {
            this.append(sb, "help:expressions", 0);
            this.append(sb, "Displays the supported Plugin expressions used by Maven.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "help:help", 0);
            this.append(sb, "Display help information on maven-help-plugin.\nCall\n\u00a0\u00a0mvn\u00a0help:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "system".equals(this.goal)) {
            this.append(sb, "help:system", 0);
            this.append(sb, "Displays a list of the platform details like system properties and environment variables.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

