/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.gpg.GpgSigner;
import org.apache.maven.plugin.gpg.SigningBundle;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

public class GpgSignAttachedMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.md5", "**/*.sha1", "**/*.asc"};
    private String passphrase;
    private String keyname;
    private boolean useAgent;
    private boolean skip;
    private String[] excludes;
    private File outputDirectory;
    protected MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactHandlerManager artifactHandlerManager;
    protected Settings settings;
    private GpgSigner signer = new GpgSigner();

    public void execute() throws MojoExecutionException {
        File projectArtifact;
        File projectArtifactSignature;
        String pass = this.passphrase;
        if (this.skip) {
            return;
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
        }
        String[] newExcludes = new String[this.excludes.length];
        for (int i = 0; i < this.excludes.length; ++i) {
            String pattern = this.excludes[i].trim().replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (pattern.endsWith(File.separator)) {
                pattern = pattern + "**";
            }
            newExcludes[i] = pattern;
        }
        this.excludes = newExcludes;
        if (!this.useAgent && null == pass) {
            if (!this.settings.isInteractiveMode()) {
                throw new MojoExecutionException("Cannot obtain passphrase in batch mode");
            }
            try {
                pass = this.signer.getPassphrase(this.project);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception reading password", (Exception)e);
            }
        }
        this.signer.setInteractive(this.settings.isInteractiveMode());
        this.signer.setKeyName(this.keyname);
        this.signer.setUseAgent(this.useAgent);
        this.signer.setOutputDirectory(this.outputDirectory);
        this.signer.setBuildDirectory(new File(this.project.getBuild().getDirectory()));
        this.signer.setBaseDirectory(this.project.getBasedir());
        ArrayList<SigningBundle> signingBundles = new ArrayList<SigningBundle>();
        if (!"pom".equals(this.project.getPackaging()) && (projectArtifactSignature = this.signer.generateSignatureForArtifact(projectArtifact = this.project.getArtifact().getFile(), pass)) != null) {
            signingBundles.add(new SigningBundle(this.project.getArtifact().getType(), projectArtifactSignature));
        }
        File pomToSign = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".pom");
        try {
            FileUtils.copyFile((File)this.project.getFile(), (File)pomToSign);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying POM for signing.", (Exception)e);
        }
        File pomSignature = this.signer.generateSignatureForArtifact(pomToSign, pass);
        if (pomSignature != null) {
            signingBundles.add(new SigningBundle("pom", pomSignature));
        }
        Iterator i = this.project.getAttachedArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            File file = artifact.getFile();
            File signature = this.signer.generateSignatureForArtifact(file, pass);
            if (signature == null) continue;
            signingBundles.add(new SigningBundle(artifact.getType(), artifact.getClassifier(), signature));
        }
        DefaultArtifactHandler handler = new DefaultArtifactHandler("asc");
        HashMap<String, DefaultArtifactHandler> map = new HashMap<String, DefaultArtifactHandler>();
        map.put("asc", handler);
        this.artifactHandlerManager.addHandlers(map);
        Iterator i2 = signingBundles.iterator();
        while (i2.hasNext()) {
            SigningBundle bundle = (SigningBundle)i2.next();
            ArtifactHandler ah = this.artifactHandlerManager.getArtifactHandler(bundle.getArtifactType());
            if (bundle.getClassifier() != null && !"".equals(bundle.getClassifier())) {
                this.projectHelper.attachArtifact(this.project, "asc", bundle.getClassifier() + "." + ah.getExtension(), bundle.getSignature());
                continue;
            }
            this.projectHelper.attachArtifact(this.project, ah.getExtension() + ".asc", null, bundle.getSignature());
        }
    }

    protected boolean isExcluded(String name) {
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!SelectorUtils.matchPath((String)this.excludes[i], (String)name)) continue;
            return true;
        }
        return false;
    }
}

