/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class EarMavenArchiver
extends MavenArchiver {
    public static final String CLASS_PATH_KEY = "Class-Path";
    private final List earModules;

    public EarMavenArchiver(List earModules) {
        this.earModules = earModules;
    }

    public Manifest getManifest(MavenProject project, MavenArchiveConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        Manifest manifest = super.getManifest(project, config);
        if (config.getManifest().isAddClasspath()) {
            Manifest.Attribute classPathAttr;
            String earManifestClassPathEntry = this.generateClassPathEntry(config.getManifest().getClasspathPrefix());
            String userSuppliedClassPathEntry = this.getUserSuppliedClassPathEntry(config);
            if (userSuppliedClassPathEntry != null) {
                earManifestClassPathEntry = userSuppliedClassPathEntry + " " + earManifestClassPathEntry;
            }
            if ((classPathAttr = manifest.getMainSection().getAttribute(CLASS_PATH_KEY)) != null) {
                classPathAttr.setValue(earManifestClassPathEntry);
            } else {
                Manifest.Attribute attr = new Manifest.Attribute(CLASS_PATH_KEY, earManifestClassPathEntry);
                manifest.addConfiguredAttribute(attr);
            }
        }
        return manifest;
    }

    protected String generateClassPathEntry(String classPathPrefix) {
        StringBuffer classpath = new StringBuffer();
        Iterator it = this.earModules.iterator();
        while (it.hasNext()) {
            EarModule earModule = (EarModule)it.next();
            if (earModule.isExcluded()) continue;
            classpath.append(classPathPrefix).append(earModule.getUri()).append(" ");
        }
        return classpath.toString().trim();
    }

    protected String getUserSuppliedClassPathEntry(MavenArchiveConfiguration config) {
        if (config.getManifestEntries() != null) {
            Set keys = config.getManifestEntries().keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)config.getManifestEntries().get(key);
                if (!CLASS_PATH_KEY.equals(key) || value == null) continue;
                return value;
            }
        }
        return null;
    }
}

