/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

class EnvEntry {
    static final String ENV_ENTRY = "env-entry";
    static final String DESCRIPTION = "description";
    static final String ENV_ENTRY_NAME = "env-entry-name";
    static final String ENV_ENTRY_TYPE = "env-entry-type";
    static final String ENV_ENTRY_VALUE = "env-entry-value";
    private final String description;
    private final String name;
    private final String type;
    private final String value;

    public EnvEntry(String description, String name, String type, String value) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("env-entry-name in env-entry element cannot be null.");
        }
        if (StringUtils.isEmpty((String)type) && StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("env-entry-type in env-entry element cannot be null if no env-entry-value was specified.");
        }
        this.description = description;
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void appendEnvEntry(XMLWriter writer) {
        System.out.println("appendEnvEntry()");
        writer.startElement(ENV_ENTRY);
        if (this.getDescription() != null) {
            this.doWriteElement(writer, DESCRIPTION, this.getDescription());
        }
        this.doWriteElement(writer, ENV_ENTRY_NAME, this.getName());
        if (this.getType() != null) {
            this.doWriteElement(writer, ENV_ENTRY_TYPE, this.getType());
        }
        if (this.getValue() != null) {
            this.doWriteElement(writer, ENV_ENTRY_VALUE, this.getValue());
        }
        writer.endElement();
    }

    private void doWriteElement(XMLWriter writer, String element, String text) {
        writer.startElement(element);
        writer.writeText(text);
        writer.endElement();
    }

    public String toString() {
        return "env-entry [name=" + this.getName() + ", type=" + this.getType() + ", value=" + this.getValue() + "]";
    }
}

