/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.translators;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.dependency.utils.translators.ArtifactTranslator;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.codehaus.plexus.util.StringUtils;

public class ClassifierTypeTranslator
implements ArtifactTranslator {
    private ArtifactHandlerManager artifactHandlerManager;
    private String classifier;
    private String type;

    public ClassifierTypeTranslator(ArtifactHandlerManager artifactHanderManager, String theClassifier, String theType) {
        this.artifactHandlerManager = artifactHanderManager;
        this.classifier = theClassifier;
        this.type = theType;
    }

    @Override
    public Set<ArtifactCoordinate> translate(Set<Artifact> artifacts, Log log) {
        log.debug((CharSequence)("Translating Artifacts using Classifier: " + this.classifier + " and Type: " + this.type));
        HashSet<ArtifactCoordinate> results = new HashSet<ArtifactCoordinate>();
        for (Artifact artifact : artifacts) {
            String useType = StringUtils.isNotEmpty((String)this.type) ? this.type : artifact.getType();
            ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(useType);
            String extension = artifactHandler != null ? artifactHandler.getExtension() : this.type;
            String useClassifier = StringUtils.isNotEmpty((String)this.classifier) ? this.classifier : artifact.getClassifier();
            DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
            coordinate.setGroupId(artifact.getGroupId());
            coordinate.setArtifactId(artifact.getArtifactId());
            coordinate.setVersion(artifact.getVersion());
            coordinate.setClassifier(useClassifier);
            coordinate.setExtension(extension);
            results.add((ArtifactCoordinate)coordinate);
        }
        return results;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String theClassifier) {
        this.classifier = theClassifier;
    }
}

