/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromConfiguration;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugins.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugins.dependency.utils.markers.UnpackFileMarkerHandler;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="unpack", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false, threadSafe=true)
public class UnpackMojo
extends AbstractFromConfigurationMojo {
    @Parameter(defaultValue="${project.build.directory}/dependency-maven-plugin-markers")
    private File markersDirectory;
    @Parameter(property="mdep.unpack.includes")
    private String includes;
    @Parameter(property="mdep.unpack.excludes")
    private String excludes;
    @Parameter(property="artifact")
    private String artifact;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            return;
        }
        this.verifyRequirements();
        List<ArtifactItem> processedItems = this.getProcessedArtifactItems(false);
        for (ArtifactItem artifactItem : processedItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.unpackArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem.getArtifact().getFile().getName() + " already unpacked."));
        }
    }

    private void unpackArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(artifactItem, this.markersDirectory);
        this.unpack(artifactItem.getArtifact(), artifactItem.getType(), artifactItem.getOutputDirectory(), artifactItem.getIncludes(), artifactItem.getExcludes(), artifactItem.getEncoding());
        handler.setMarker();
    }

    @Override
    ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(item, this.markersDirectory);
        return new MarkerFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), handler);
    }

    protected List<ArtifactItem> getProcessedArtifactItems(boolean removeVersion) throws MojoExecutionException {
        List<ArtifactItem> items = super.getProcessedArtifactItems(new ProcessArtifactItemsRequest(removeVersion, false, false, false));
        for (ArtifactItem artifactItem : items) {
            if (StringUtils.isEmpty((String)artifactItem.getIncludes())) {
                artifactItem.setIncludes(this.getIncludes());
            }
            if (!StringUtils.isEmpty((String)artifactItem.getExcludes())) continue;
            artifactItem.setExcludes(this.getExcludes());
        }
        return items;
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

