/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changelog.scm.provider.svn.svnexe.command.info;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.info.SvnInfoConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnInfoCommandExpanded
extends AbstractCommand
implements SvnCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return this.executeInfoCommand((SvnScmProviderRepository)repository, fileSet, parameters, false, null);
    }

    public InfoScmResult executeInfoCommand(SvnScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters, boolean recursive, String revision) throws ScmException {
        Commandline cl = SvnInfoCommandExpanded.createCommandLine(repository, fileSet, recursive, revision);
        return this.executeInfoCommand(cl);
    }

    public InfoScmResult executeInfoTagCommand(SvnScmProviderRepository repository, ScmFileSet fileSet, String tag, CommandParameters parameters, boolean recursive, String revision) throws ScmException {
        Commandline cl = SvnInfoCommandExpanded.createTagCommandLine(repository, fileSet, tag, recursive, revision);
        return this.executeInfoCommand(cl);
    }

    private InfoScmResult executeInfoCommand(Commandline cl) throws ScmException {
        int exitCode;
        SvnInfoConsumer consumer = new SvnInfoConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword((Commandline)cl));
            this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = SvnCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new InfoScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new InfoScmResult(cl.toString(), consumer.getInfoItems());
    }

    protected static Commandline createCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, boolean recursive, String revision) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)fileSet.getBasedir(), (SvnScmProviderRepository)repository);
        cl.createArg().setValue("info");
        if (recursive) {
            cl.createArg().setValue("--recursive");
        }
        if (revision != null && !revision.isEmpty()) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(revision);
        }
        for (File file : fileSet.getFileList()) {
            if (repository == null) {
                cl.createArg().setValue(file.getPath());
                continue;
            }
            cl.createArg().setValue(repository.getUrl() + "/" + file.getPath().replace('\\', '/'));
        }
        return cl;
    }

    protected static Commandline createTagCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, String tag, boolean recursive, String revision) {
        Iterator it;
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)fileSet.getBasedir(), (SvnScmProviderRepository)repository);
        cl.createArg().setValue("info");
        if (recursive) {
            cl.createArg().setValue("--recursive");
        }
        if (revision != null && !revision.isEmpty()) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(revision);
        }
        if (!(it = fileSet.getFileList().iterator()).hasNext()) {
            String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag));
            cl.createArg().setValue(SvnCommandUtils.fixUrl((String)tagUrl, (String)repository.getUser()));
        } else {
            while (it.hasNext()) {
                File file = (File)it.next();
                if (repository == null) {
                    cl.createArg().setValue(file.getPath());
                    continue;
                }
                String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag)) + "/" + file.getPath().replace('\\', '/');
                cl.createArg().setValue(SvnCommandUtils.fixUrl((String)tagUrl, (String)repository.getUser()));
            }
        }
        return cl;
    }
}

