/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changelog;

import java.util.Comparator;
import java.util.List;
import org.apache.maven.scm.ChangeFile;

public class FileActivityComparator
implements Comparator<List<ChangeFile>> {
    @Override
    public int compare(List<ChangeFile> list1, List<ChangeFile> list2) throws ClassCastException {
        int returnValue = Integer.compare(list2.size(), list1.size());
        if (returnValue != 0) {
            return returnValue;
        }
        returnValue = this.sortByRevision(list1, list2);
        if (returnValue != 0) {
            return returnValue;
        }
        return this.sortByName(list1, list2);
    }

    private int sortByRevision(List<ChangeFile> list1, List<ChangeFile> list2) {
        String revision1 = this.getLatestRevision(list1);
        String revision2 = this.getLatestRevision(list2);
        if (revision1 == null) {
            return -1;
        }
        if (revision2 == null) {
            return 1;
        }
        return revision1.compareTo(revision2);
    }

    private String getLatestRevision(List<ChangeFile> list) {
        String latest = "";
        for (ChangeFile file : list) {
            if (latest != null && !latest.trim().isEmpty()) {
                latest = file.getRevision();
                continue;
            }
            if (latest.compareTo(file.getRevision()) >= 0) continue;
            latest = file.getRevision();
        }
        return latest;
    }

    private int sortByName(List<ChangeFile> list1, List<ChangeFile> list2) {
        ChangeFile file1 = list1.get(0);
        ChangeFile file2 = list2.get(0);
        return file1.getName().compareTo(file2.getName());
    }
}

